/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.database;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.AbstractMetadataNode;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.transaction.Transactional;

@Named
@Singleton
public class OrientYumQueryComponent
extends ComponentSupport {
    private static final String ASSET_KIND_KEY = "attributes.yum.asset_kind";
    private static final String RPMS_REMOVED_KEY = "attributes.yum.rpms_removed";
    private static final String RPMS_SINCE_QUERY = "SELECT FROM asset WHERE bucket=:bucket AND blob_updated > :blobupdated AND component IS NOT NULL";
    private static final String REPOMD_PATH = "repodata/repomd.xml";
    private static final String COMPS_PATH = "repodata/comps.xml";
    private final AssetEntityAdapter assetEntityAdapter;
    private final int bufferSize;
    private final int bufferTimeoutSeconds;

    @Inject
    public OrientYumQueryComponent(AssetEntityAdapter assetEntityAdapter, @Named(value="${nexus.yum.browseQuery.bufferSize:-128}") int bufferSize, @Named(value="${nexus.yum.browseQuery.bufferTimeoutSeconds:-60}") int bufferTimeoutSeconds) {
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
        this.bufferSize = bufferSize;
        this.bufferTimeoutSeconds = bufferTimeoutSeconds;
    }

    @Nullable
    public Component findComponent(StorageTx tx, Repository repository, String name, String version) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    public Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    public Iterable<Asset> findRepodataAssets(StorageTx tx, Repository repository) {
        Query query = Query.builder().where("component").isNull().and("name").like((Object)"%repodata/%").and(ASSET_KIND_KEY).eq((Object)AssetKind.REPODATA.name()).build();
        this.log.debug("Finding repodata {}", (Object)repository.getName());
        return tx.findAssets(query, Collections.singletonList(repository));
    }

    public Iterable<Asset> findRepomdSignatures(StorageTx tx, Repository repository) {
        Query query = Query.builder().where("component").isNull().and("name").like((Object)"%repodata/repomd.xml.asc").and(ASSET_KIND_KEY).eq((Object)AssetKind.REPOMD_ASC.name()).build();
        this.log.debug("Finding repodata signatures {}", (Object)repository.getName());
        return tx.findAssets(query, Collections.singletonList(repository));
    }

    @Transactional
    public Iterable<Asset> findRepodataAssetsOnPath(Supplier<StorageTx> txSupplier, Repository repository, String path) {
        Query query = this.repoDataQuery(path);
        this.log.debug("Finding repodata in {}:{}", (Object)repository.getName(), (Object)path);
        return txSupplier.get().findAssets(query, Collections.singletonList(repository));
    }

    public Query repoDataQuery(String path) {
        return Query.builder().where("component").isNull().and("name").like((Object)(String.valueOf(path) + "%")).and(ASSET_KIND_KEY).eq((Object)AssetKind.REPODATA.name()).build();
    }

    @Transactional
    public Iterable<Asset> findRepomd(Supplier<StorageTx> txSupplier, Repository repository) {
        this.log.debug("Finding repomd in {}", (Object)repository.getName());
        return txSupplier.get().findAssets(this.buildRepomdQuery(null), Collections.singletonList(repository));
    }

    public Iterable<Asset> findRepomdOnPath(StorageTx tx, Repository repository, @Nullable String path) {
        this.log.debug("Finding repomd in {}:{}", (Object)repository.getName(), (Object)path);
        return tx.findAssets(this.buildRepomdQuery(path), Collections.singletonList(repository));
    }

    private Query buildRepomdQuery(@Nullable String path) {
        Query.Builder builder = Query.builder();
        if (StringUtils.isNotBlank((CharSequence)path)) {
            builder.where("name").eq((Object)(String.valueOf(path) + "/" + REPOMD_PATH));
        } else {
            builder.where("name").eq((Object)REPOMD_PATH);
        }
        builder.and(ASSET_KIND_KEY).eq((Object)AssetKind.REPOMD.name());
        return builder.build();
    }

    public Iterable<Asset> browseRpms(StorageTx tx, Repository repository) {
        return Iterables.filter((Iterable)tx.browseAssets(tx.findBucket(repository)), asset -> AssetKind.RPM.toString().equals(asset.formatAttributes().get("asset_kind", String.class)));
    }

    @Transactional
    public Iterable<Asset> browseRpmsForPath(String path, Supplier<StorageTx> txSupplier, Repository repository) {
        Query.Builder builder = Query.builder().where("component").isNotNull();
        if (!StringUtils.isBlank((CharSequence)path)) {
            builder.and("name").like((Object)(String.valueOf(path) + "%"));
        }
        Query query = builder.and(ASSET_KIND_KEY).eq((Object)AssetKind.RPM.name()).build();
        this.log.debug("Browsing RPMs in {}:{}", (Object)repository.getName(), (Object)path);
        StorageTx storageTx = txSupplier.get();
        return storageTx.browseAssets(query, storageTx.findBucket(repository), this.bufferSize, this.bufferTimeoutSeconds);
    }

    @Transactional
    public Iterable<Asset> browseRpmBlobsUpdatedSince(@Nullable String path, Supplier<StorageTx> txSupplier, Repository repository, long since) {
        String query = RPMS_SINCE_QUERY;
        if (StringUtils.isNotBlank((CharSequence)path)) {
            query = String.valueOf(query) + " AND name LIKE :path";
        }
        Bucket bucket = txSupplier.get().findBucket(repository);
        ImmutableMap params = ImmutableMap.of((Object)"bucket", (Object)AttachedEntityHelper.id((Entity)bucket), (Object)"blobupdated", (Object)since, (Object)"path", (Object)(String.valueOf(path) + "%"));
        this.log.debug("Finding RPMs last updated with query: {} params: {}", (Object)query, (Object)params);
        return Iterables.transform((Iterable)txSupplier.get().browse(query, (Map)params, this.bufferSize, (long)this.bufferTimeoutSeconds), arg_0 -> ((AssetEntityAdapter)this.assetEntityAdapter).readEntity(arg_0));
    }

    @Transactional
    public Iterable<Asset> findAssetsByComponentIds(@Nullable String path, Supplier<StorageTx> txSupplier, List<String> componentIds, Repository repository) {
        if (componentIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query.Builder builder = Query.builder().where("component.@rid.asString()").in("componentRid", componentIds);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            builder.and("name").like((Object)(String.valueOf(path) + "%"));
        }
        Query query = builder.build();
        String whereClause = query.getWhere();
        Map params = query.getParameters();
        this.log.debug("Finding RPMs from component id with repository: {} query: {} params: {}", new Object[]{repository.getName(), whereClause, params});
        return txSupplier.get().findAssets(whereClause, params, Collections.singletonList(repository), null);
    }

    @Transactional
    public Iterable<Asset> findCompsByPath(@Nullable String path, Supplier<StorageTx> txSupplier, Repository repository) {
        String expectedPath = StringUtils.isNotBlank((CharSequence)path) ? String.valueOf(path) + "/" + COMPS_PATH : COMPS_PATH;
        Query query = Query.builder().where("name").eq((Object)expectedPath).or("name").eq((Object)(String.valueOf(expectedPath) + ".gz")).build();
        this.log.debug("Finding COMPS in {}:{}", (Object)repository.getName(), (Object)path);
        return txSupplier.get().findAssets(query, Collections.singletonList(repository));
    }

    public long countRpms(Supplier<StorageTx> txSupplier, Repository repository) {
        return this.countRpmsInDirectoryInNewTx(null, txSupplier, repository);
    }

    @Transactional
    public long countRpmsInDirectoryInNewTx(@Nullable String folder, Supplier<StorageTx> txSupplier, Repository repository) {
        this.log.debug("Counting RPMs in {}:{}", (Object)repository.getName(), (Object)folder);
        return txSupplier.get().countAssets(this.buildRpmCountQuery(folder).build(), Collections.singletonList(repository));
    }

    public long countRpmsInDirectory(@Nullable String folder, StorageTx tx, Repository repository) {
        this.log.debug("Counting RPMs in {}:{}", (Object)repository.getName(), (Object)folder);
        return tx.countAssets(this.buildRpmCountQuery(folder).build(), Collections.singletonList(repository));
    }

    @Transactional
    public long countComps(Supplier<StorageTx> txSupplier, Repository repository) {
        this.log.debug("Counting Comps in {}", (Object)repository.getName());
        return txSupplier.get().countAssets(this.buildCompsCountQuery().build(), Collections.singletonList(repository));
    }

    private Query.Builder buildRpmCountQuery(@Nullable String folder) {
        Query.Builder query = Query.builder();
        query.where("component").isNotNull();
        if (StringUtils.isNotBlank((CharSequence)folder)) {
            String pathPrefix = folder.endsWith("/") ? folder : String.valueOf(folder) + '/';
            query = query.and("name").like((Object)(String.valueOf(pathPrefix) + "%"));
        }
        return query;
    }

    private Query.Builder buildCompsCountQuery() {
        return Query.builder().where("component").isNull().and("name").like((Object)"%repodata/comps.xml");
    }

    @Transactional
    public Iterable<Asset> browseCompsUpdatedSince(Supplier<StorageTx> txSupplier, Repository repository, long since) {
        String query = "SELECT FROM asset WHERE bucket=:bucket AND blob_updated > :blobupdated AND component IS NULL AND name LIKE :path";
        Bucket bucket = txSupplier.get().findBucket(repository);
        ImmutableMap params = ImmutableMap.of((Object)"bucket", (Object)AttachedEntityHelper.id((Entity)bucket), (Object)"blobupdated", (Object)since, (Object)"path", (Object)"%repodata/comps.xml");
        this.log.debug("Finding Comps last updated with query: {} params: {}", (Object)query, (Object)params);
        return Iterables.transform((Iterable)txSupplier.get().browse(query, (Map)params, this.bufferSize, (long)this.bufferTimeoutSeconds), arg_0 -> ((AssetEntityAdapter)this.assetEntityAdapter).readEntity(arg_0));
    }

    @Transactional
    public Iterable<Asset> browseAllComps(Supplier<StorageTx> txSupplier, Repository repository) {
        String query = "SELECT FROM asset WHERE bucket=:bucket AND component IS NULL  AND name LIKE :path";
        Bucket bucket = txSupplier.get().findBucket(repository);
        ImmutableMap params = ImmutableMap.of((Object)"bucket", (Object)AttachedEntityHelper.id((Entity)bucket), (Object)"path", (Object)"%repodata/comps.xml");
        this.log.debug("Finding all COMPS with query: {} params: {}", (Object)query, (Object)params);
        return Iterables.transform((Iterable)txSupplier.get().browse(query, (Map)params, this.bufferSize, (long)this.bufferTimeoutSeconds), arg_0 -> ((AssetEntityAdapter)this.assetEntityAdapter).readEntity(arg_0));
    }

    @Transactional
    public List<String> getMetadataPathsThatHaveHadRpmsRemoved(Supplier<StorageTx> txSupplier, Repository repository) {
        Query.Builder builder = Query.builder().where("component").isNull().and("name").like((Object)"%repomd.xml").and(ASSET_KIND_KEY).eq((Object)AssetKind.REPOMD.name()).and(RPMS_REMOVED_KEY).eq((Object)true);
        Query query = builder.build();
        this.log.debug("Getting repomds with RPMS removed using query: '{}'", (Object)query);
        return StreamSupport.stream(txSupplier.get().findAssets(query, Collections.singletonList(repository)).spliterator(), false).map(AbstractMetadataNode::name).collect(Collectors.toList());
    }
}

