/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal.createrepo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.AbstractMetadataNode;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoService;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.RpmRedeployedEvent;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumCleanupMetadataEvent;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataInvalidationEvent;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedFacet;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientCreateRepoFacetImpl
extends FacetSupport
implements CreateRepoFacet,
EventAware.Asynchronous {
    private final CreateRepoService createRepo;
    private final EventManager eventManager;
    private final long interval;
    private final long cleanUpInterval;
    private final AtomicBoolean acceptingEvents = new AtomicBoolean(true);
    private final AtomicBoolean eventFired = new AtomicBoolean(false);
    private final AtomicBoolean isCleanupSleep = new AtomicBoolean(false);
    private final ListMultimap<String, String> deprecatedMetadataFiles = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final boolean cachingEnabled;
    @VisibleForTesting
    Clock clock = new Clock();

    @Inject
    public OrientCreateRepoFacetImpl(CreateRepoService createRepo, EventManager eventManager, @Named(value="${nexus.yum.createrepo.interval:-60000}") long interval, @Named(value="${nexus.yum.createrepo.cleanUpInterval:-30000}") long cleanUpInterval, @Named(value="${nexus.yum.createrepo.caching:-true}") boolean cachingEnabled) {
        this.createRepo = (CreateRepoService)Preconditions.checkNotNull((Object)createRepo);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.interval = interval;
        this.cleanUpInterval = cleanUpInterval;
        this.cachingEnabled = cachingEnabled;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent deleted) {
        if (this.matchesRepository((AssetEvent)deleted) && this.isEventRelevant((AssetEvent)deleted)) {
            this.invalidateMetadata();
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent created) {
        if (this.matchesRepository((AssetEvent)created) && this.isEventRelevant((AssetEvent)created)) {
            this.invalidateMetadata();
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(RpmRedeployedEvent redeployEvent) {
        if (this.getRepository().getName().equals(redeployEvent.getRepositoryName())) {
            this.invalidateMetadata();
        }
    }

    @Override
    public synchronized void invalidateMetadata() {
        if (this.acceptingEvents.get() && !this.eventFired.get()) {
            this.log.info("Scheduling rebuild of yum metadata to start for repository {} in {} seconds", (Object)this.getRepository().getName(), (Object)(this.interval / 1000L));
            this.eventFired.set(true);
            this.eventManager.post((Object)new YumMetadataInvalidationEvent(this.getRepository().getName(), true, true));
        } else {
            this.log.debug("Skipping metadata rebuild, another event already queued.");
        }
    }

    @Override
    public void invalidateMetadataWithoutWaiting(boolean useCache) {
        this.invalidateMetadataWithoutWaiting(useCache, Collections.emptyList());
    }

    @Override
    public void invalidateMetadataWithoutWaiting(boolean useCache, List<String> movedComponentIds) {
        this.eventFired.set(true);
        this.log.info("Invalidating of yum metadata without waiting with repository: {} additional components size: {}", (Object)this.getRepository().getName(), (Object)movedComponentIds.size());
        this.eventManager.post((Object)new YumMetadataInvalidationEvent(this.getRepository().getName(), false, useCache, movedComponentIds));
    }

    @Subscribe
    public void on(YumMetadataInvalidationEvent event) {
        if (this.shouldProcess(event)) {
            this.acceptingEvents.set(false);
            this.maybeWait(event);
            this.log.info("Rebuilding yum metadata for repository {}", (Object)this.getRepository().getName());
            ArrayList<String> metadataFilesToDelete = new ArrayList<String>();
            UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
            try {
                this.acceptingEvents.set(true);
                this.eventFired.set(false);
                long startTime = this.clock.millis();
                this.buildMetadata(event, blobs -> {
                    boolean bl = metadataFilesToDelete.addAll(this.updateMetadata((List<MetadataBlob>)blobs));
                });
                ((OrientYumHostedFacet)this.getRepository().facet(OrientYumHostedFacet.class)).metadataGenerationStarted(startTime);
                this.log.info("Finished rebuilding yum metadata for repository {}", (Object)this.getRepository().getName());
            }
            finally {
                UnitOfWork.end();
            }
            if (!metadataFilesToDelete.isEmpty()) {
                this.eventManager.post((Object)new YumCleanupMetadataEvent(this.getRepository().getName(), metadataFilesToDelete));
            }
        }
    }

    @Subscribe
    public void on(YumCleanupMetadataEvent event) {
        if (!event.getRepositoryName().equals(this.getRepository().getName())) {
            return;
        }
        this.deprecatedMetadataFiles.putAll((Object)this.getRepository().getName(), event.getDeprecatedMetadata());
        if (this.isCleanupSleep.get()) {
            return;
        }
        this.maybeWaitForCleanup();
        this.log.debug("Cleanup metadata is running for repository {}", (Object)this.getRepository().getName());
        UnitOfWork.begin((Supplier)((StorageFacet)this.facet(StorageFacet.class)).txSupplier());
        ArrayList<String> assetPathsToRemove = new ArrayList<String>(this.deprecatedMetadataFiles.get((Object)this.getRepository().getName()));
        try {
            ((OrientYumHostedFacet)this.facet(OrientYumHostedFacet.class)).delete(assetPathsToRemove);
        }
        finally {
            UnitOfWork.end();
        }
        this.log.debug("Finished cleanup metadata for repository {}", (Object)this.getRepository().getName());
        assetPathsToRemove.forEach(it -> {
            boolean bl = this.deprecatedMetadataFiles.remove((Object)this.getRepository().getName(), it);
        });
    }

    private void maybeWaitForCleanup() {
        if (this.cleanUpInterval <= 0L) {
            return;
        }
        this.isCleanupSleep.set(true);
        try {
            try {
                Thread.sleep(this.cleanUpInterval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("Yum clean up metadata thread interrupted");
                this.isCleanupSleep.set(false);
            }
        }
        finally {
            this.isCleanupSleep.set(false);
        }
    }

    private void buildMetadata(YumMetadataInvalidationEvent event, Consumer<List<MetadataBlob>> updateListener) {
        if (this.cachingEnabled && event.isUseCache()) {
            this.createRepo.buildMetadataUsingCaching(this.getRepository(), updateListener, event.getMovedComponentIds());
        } else {
            this.createRepo.buildMetadataWithoutCaching(this.getRepository(), updateListener);
        }
    }

    private boolean shouldProcess(YumMetadataInvalidationEvent event) {
        return this.getRepository().getName().equals(event.getRepositoryName());
    }

    private void maybeWait(YumMetadataInvalidationEvent event) {
        if (event.isWaitBeforeRebuild()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("Yum invalidation thread interrupted, proceeding with invalidation");
            }
        }
    }

    protected List<String> updateMetadata(List<MetadataBlob> metadataBlobs) {
        OrientYumHostedFacet hosted = (OrientYumHostedFacet)this.getRepository().facet(OrientYumHostedFacet.class);
        String[] excludeFromDelete = (String[])metadataBlobs.stream().map(MetadataBlob::getPath).toArray(String[]::new);
        List<String> directoriesToDelete = metadataBlobs.stream().map(MetadataBlob::getPath).map(YumPathUtils::extractDirectoryFromMetadataPath).filter(path -> !path.isEmpty()).collect(Collectors.toList());
        this.updateEachMetadataFile(hosted, metadataBlobs);
        this.markDirectoryModified(hosted, metadataBlobs);
        List<Asset> metadataFilesToDelete = hosted.getMetadataFilesToDelete(directoriesToDelete, excludeFromDelete);
        this.deleteMetadataFilesIfNoRpmsLeft(metadataFilesToDelete);
        return metadataFilesToDelete.stream().map(AbstractMetadataNode::name).collect(Collectors.toList());
    }

    private void deleteMetadataFilesIfNoRpmsLeft(List<Asset> metadataFilesToDelete) {
        Set<String> directories = this.extractDirectories(metadataFilesToDelete);
        OrientYumHostedFacet hosted = (OrientYumHostedFacet)this.getRepository().facet(OrientYumHostedFacet.class);
        for (String directory : directories) {
            hosted.deleteRepomdIfNoRpmsLeft(directory);
            hosted.deleteRepodataIfNoRpmsLeft(directory);
        }
    }

    private Set<String> extractDirectories(List<Asset> metadataFilesToDelete) {
        return metadataFilesToDelete.stream().map(AbstractMetadataNode::name).map(YumPathUtils::extractDirectoryFromMetadataPath).collect(Collectors.toSet());
    }

    private void updateEachMetadataFile(OrientYumHostedFacet hosted, List<MetadataBlob> metadataBlobs) {
        for (MetadataBlob metadataBlob : metadataBlobs) {
            try {
                hosted.putMetadata(metadataBlob.getPath(), metadataBlob.getInputStreamSupplier(), metadataBlob.getContentType(), metadataBlob.getAssetKind());
            }
            catch (IOException e) {
                this.log.error("Failed to save new metadata", (Throwable)e);
            }
        }
    }

    private void markDirectoryModified(OrientYumHostedFacet hosted, List<MetadataBlob> metadataBlobs) {
        HashSet<String> processed = new HashSet<String>();
        int depth = hosted.getRepodataDepth();
        for (MetadataBlob metadataBlob : metadataBlobs) {
            String folder = YumPathUtils.extractDirectoryAtDepth(metadataBlob.getPath(), depth).orElse("");
            if (processed.contains(folder)) continue;
            processed.add(folder);
            this.log.debug("Checking whether RPMs removed from {} during metadata generation", (Object)folder);
            hosted.setRpmsRemovedFlagIfCountChanged(StringUtils.isNotEmpty((String)folder) ? String.valueOf(folder) + "/" : folder, metadataBlob.getExpectedRpmCount());
        }
    }

    private boolean matchesRepository(AssetEvent assetEvent) {
        return assetEvent.isLocal() && this.getRepository().getName().equals(assetEvent.getRepositoryName());
    }

    private boolean isEventRelevant(AssetEvent event) {
        return event.getComponentId() != null || AssetKind.COMPS.name().equals(event.getAsset().formatAttributes().get("asset_kind", String.class));
    }
}

