/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.YumAssetAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.YumComponentAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.createrepo.RpmRedeployedEvent;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.orient.OrientYumFacet;
import org.sonatype.nexus.repository.yum.orient.internal.database.OrientYumQueryComponent;
import org.sonatype.nexus.repository.yum.orient.internal.utils.OrientYumFacetUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientYumFacetImpl
extends FacetSupport
implements OrientYumFacet {
    private YumRpmParser rpmParser;
    private YumComponentAttributePopulator yumComponentAttributePopulator;
    private YumAssetAttributePopulator yumAssetAttributePopulator;
    private final OrientYumQueryComponent orientYumQueryComponent;

    @Inject
    public OrientYumFacetImpl(YumRpmParser yumRpmParser, YumComponentAttributePopulator yumComponentAttributePopulator, YumAssetAttributePopulator yumAssetAttributePopulator, OrientYumQueryComponent orientYumQueryComponent) {
        this.rpmParser = (YumRpmParser)((Object)Preconditions.checkNotNull((Object)((Object)yumRpmParser)));
        this.yumComponentAttributePopulator = (YumComponentAttributePopulator)((Object)Preconditions.checkNotNull((Object)((Object)yumComponentAttributePopulator)));
        this.yumAssetAttributePopulator = (YumAssetAttributePopulator)((Object)Preconditions.checkNotNull((Object)((Object)yumAssetAttributePopulator)));
        this.orientYumQueryComponent = (OrientYumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)orientYumQueryComponent)));
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getAssetAsContent(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.doGetAsset(name, tx);
        if (asset == null) {
            return null;
        }
        return OrientYumFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Nullable
    private Asset doGetAsset(String name, StorageTx tx) {
        Asset asset = this.orientYumQueryComponent.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return asset;
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Asset getAsset(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return this.doGetAsset(name, tx);
    }

    @Override
    public Content storeMetadata(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind) throws IOException {
        return this.storeMetadata(assetPath, metadataContent, payload, assetKind, new AttributesMap());
    }

    @Override
    @TransactionalStoreBlob
    public Content storeMetadata(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind, AttributesMap attributesMap) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.findOrCreateAsset(assetPath, assetKind, attributesMap, tx, bucket);
        return this.saveAsset(tx, asset, (InputStreamSupplier)metadataContent, payload);
    }

    @Override
    @TransactionalStoreBlob
    public Asset storeMetadata(String assetPath, AssetBlob assetBlob, AssetKind assetKind, AttributesMap contentAttributes) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.findOrCreateAsset(assetPath, assetKind, contentAttributes, tx, bucket);
        this.saveAsset(tx, asset, assetBlob, assetKind, contentAttributes);
        return asset;
    }

    @Override
    @TransactionalStoreBlob
    public Content storeRpm(String assetPath, InputStreamSupplier rpmContent, Payload payload) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        boolean isRpmRedeploy = this.orientYumQueryComponent.findAsset(tx, bucket = tx.findBucket(this.getRepository()), assetPath) != null;
        Asset asset = this.createRpmAsset(assetPath, tx, bucket, rpmContent.get());
        Content content = this.saveAsset(tx, asset, rpmContent, payload);
        if (isRpmRedeploy) {
            this.getEventManager().post((Object)new RpmRedeployedEvent(bucket.getRepositoryName()));
        }
        return content;
    }

    @Override
    @TransactionalStoreBlob
    public Content storeRpm(String assetPath, AssetBlob assetBlob) throws IOException {
        Asset asset;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        boolean isRpmRedeploy = this.orientYumQueryComponent.findAsset(tx, bucket = tx.findBucket(this.getRepository()), assetPath) != null;
        Throwable throwable = null;
        Object var8_8 = null;
        try (InputStream inputStream = assetBlob.getBlob().getInputStream();){
            asset = this.createRpmAsset(assetPath, tx, bucket, inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        tx.attachBlob(asset, assetBlob);
        Content content = this.saveAsset(tx, asset, assetBlob, null);
        if (isRpmRedeploy) {
            this.getEventManager().post((Object)new RpmRedeployedEvent(bucket.getRepositoryName()));
        }
        return content;
    }

    @Override
    @TransactionalStoreBlob
    public Asset storeRpm(String assetPath, AssetBlob assetBlob, AttributesMap contentAttributes) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.createRpmAsset(assetPath, tx, bucket, assetBlob.getBlob().getInputStream());
        this.saveAsset(tx, asset, assetBlob, AssetKind.RPM, contentAttributes);
        return asset;
    }

    private Asset createRpmAsset(String assetPath, StorageTx tx, Bucket bucket, InputStream inputStream) throws IOException {
        YumRpm rpm;
        Throwable throwable = null;
        Object var7_7 = null;
        try (InputStream in = inputStream;){
            rpm = this.rpmParser.parse(in, assetPath);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.findOrCreateAssetAndComponent(assetPath, tx, bucket, rpm);
    }

    @Override
    public Asset findOrCreateAsset(String assetPath, AssetKind assetKind, AttributesMap attributesMap, StorageTx tx, Bucket bucket) {
        Asset asset = this.orientYumQueryComponent.findAsset(tx, bucket, assetPath);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
            for (Map.Entry entry : attributesMap) {
                asset.formatAttributes().set((String)entry.getKey(), entry.getValue());
            }
        }
        return asset;
    }

    private Asset findOrCreateAssetAndComponent(String assetPath, StorageTx tx, Bucket bucket, YumRpm rpm) {
        Asset asset = this.orientYumQueryComponent.findAsset(tx, bucket, assetPath);
        if (asset == null) {
            Component component = this.findOrCreateComponent(tx, bucket, rpm);
            asset = tx.createAsset(bucket, component);
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.RPM.name());
        }
        this.yumAssetAttributePopulator.populate(asset.formatAttributes(), rpm);
        return asset;
    }

    private Component findOrCreateComponent(StorageTx tx, Bucket bucket, YumRpm rpm) {
        Component component = this.orientYumQueryComponent.findComponent(tx, this.getRepository(), rpm.getName(), rpm.getFullVersion());
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(rpm.getName())).version(rpm.getFullVersion());
            this.yumComponentAttributePopulator.populate(component.formatAttributes(), rpm);
            tx.saveComponent(component);
        }
        return component;
    }

    private void saveAsset(StorageTx tx, Asset asset, AssetBlob assetBlob, AssetKind kind, AttributesMap contentAttributes) {
        asset.formatAttributes().set("asset_kind", (Object)kind.name());
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        tx.saveAsset(asset);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = new AttributesMap();
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return this.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, String contentType, AttributesMap contentAttributes) throws IOException {
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, YumMetadataUtils.HASH_ALGORITHMS, null, contentType, false);
        return this.saveAsset(tx, asset, assetBlob, contentAttributes);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, AssetBlob assetBlob, AttributesMap contentAttributes) {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        tx.saveAsset(asset);
        return OrientYumFacetUtils.toContent(asset, assetBlob.getBlob());
    }
}

