/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.MetadataNode;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoFacet;
import org.sonatype.nexus.repository.yum.orient.internal.hosted.OrientYumHostedFacet;

@Named(value="yum")
@Singleton
public class OrientYumComponentDirector
implements ComponentDirector {
    private final BucketStore bucketStore;
    private final RepositoryManager repositoryManager;

    @Inject
    public OrientYumComponentDirector(BucketStore bucketStore, RepositoryManager repositoryManager) {
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        return this.repositoryFor(component).map(componentRepository -> (OrientYumHostedFacet)componentRepository.facet(OrientYumHostedFacet.class)).map(yumHostedFacet -> yumHostedFacet.getComponentDepth(component)).map(componentDepth -> componentDepth >= this.repoDataDepthFor(destination)).orElse(false);
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    protected Optional<Repository> repositoryFor(Component component) {
        return Optional.of(component).map(MetadataNode::bucketId).map(arg_0 -> ((BucketStore)this.bucketStore).getById(arg_0)).map(Bucket::getRepositoryName).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0));
    }

    protected Integer repoDataDepthFor(Repository repository) {
        return ((OrientYumHostedFacet)repository.facet(OrientYumHostedFacet.class)).getRepodataDepth();
    }

    public void afterMove(List<Map<String, String>> components, Repository destination) {
        CreateRepoFacet createRepoFacet = (CreateRepoFacet)destination.facet(CreateRepoFacet.class);
        List<String> componentIds = this.getComponentIds(components);
        createRepoFacet.invalidateMetadataWithoutWaiting(true, componentIds);
    }

    private List<String> getComponentIds(List<Map<String, String>> components) {
        return components.stream().map(c -> (String)c.get("id")).collect(Collectors.toList());
    }
}

