/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.orient.internal;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.yum.internal.gpg.AbstractSignaturesCleaner;
import org.sonatype.nexus.repository.yum.orient.internal.database.OrientYumQueryComponent;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class OrientSignaturesCleaner
extends AbstractSignaturesCleaner {
    private OrientYumQueryComponent orientYumQueryComponent;

    @Inject
    public OrientSignaturesCleaner(OrientYumQueryComponent orientYumQueryComponent) {
        this.orientYumQueryComponent = (OrientYumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)orientYumQueryComponent)));
    }

    @Override
    protected void deleteSignatures(Repository repository) {
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            this.deleteSignaturesTx(repository);
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected void deleteSignaturesTx(Repository repository) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterable<Asset> signatures = this.orientYumQueryComponent.findRepomdSignatures(tx, repository);
        signatures.forEach(arg_0 -> ((StorageTx)tx).deleteAsset(arg_0));
    }
}

