/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.xmltools;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonatype.nexus.repository.yum.internal.xmltools.XmlValueExtractor;

public class ElementXmlValueExtractor
implements XmlValueExtractor {
    private final String elementName;

    public ElementXmlValueExtractor(String elementName) {
        this.elementName = (String)Preconditions.checkNotNull((Object)elementName);
    }

    @Override
    @Nullable
    public String extract(Collection<XMLEvent> block) {
        Iterator<XMLEvent> eventIterator = block.iterator();
        while (eventIterator.hasNext()) {
            StartElement startElement;
            XMLEvent event = eventIterator.next();
            if (!event.isStartElement() || !(startElement = event.asStartElement()).getName().getLocalPart().equals(this.elementName) || !eventIterator.hasNext()) continue;
            XMLEvent nextEvent = eventIterator.next();
            return nextEvent.asCharacters().getData();
        }
        return null;
    }
}

