/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.MultiHashingInputStream;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;

public class YumMetadataUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA512, (Object)HashAlgorithm.MD5);
    private static final String GZ = ".gz";
    private static final String XZ = ".xz";
    private static final String BZIP = ".bz2";

    private YumMetadataUtils() {
    }

    public static YumMetadata readCompressedMetadata(YumMetadataFile metadataFile) throws IOException {
        return YumMetadataUtils.readCompressedMetadata(metadataFile, Files.newInputStream(metadataFile.getPath(), new OpenOption[0]));
    }

    /*
     * Loose catch block
     */
    public static YumMetadata readCompressedMetadata(YumMetadataFile metadataFile, InputStream metadata) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(metadata);){
            YumMetadata yumMetadata;
            InputStream inputStream;
            Throwable throwable2;
            block19: {
                CountingInputStream countStream = new CountingInputStream((InputStream)in);
                MultiHashingInputStream hash = new MultiHashingInputStream(HASH_ALGORITHMS, (InputStream)countStream);
                throwable2 = null;
                Object var8_11 = null;
                inputStream = YumMetadataUtils.xmlInputStream(YumMetadataUtils.getFileName(metadataFile), (InputStream)hash);
                CountingInputStream openCountStream = new CountingInputStream(inputStream);
                MultiHashingInputStream openHash = new MultiHashingInputStream(HASH_ALGORITHMS, (InputStream)openCountStream);
                ByteStreams.copy((InputStream)openHash, (OutputStream)ByteStreams.nullOutputStream());
                yumMetadata = new YumMetadata(metadataFile.getType()).setChecksum(((HashCode)hash.hashes().get(HashAlgorithm.SHA256)).toString()).setOpenChecksum(((HashCode)openHash.hashes().get(HashAlgorithm.SHA256)).toString()).setSize(countStream.getCount()).setOpenSize(openCountStream.getCount());
                if (inputStream == null) break block19;
                inputStream.close();
            }
            return yumMetadata;
            {
                catch (Throwable throwable3) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private static String getFileName(YumMetadataFile metadataFile) {
        if (metadataFile != null && metadataFile.getPath() != null && metadataFile.getPath().getFileName() != null) {
            return metadataFile.getPath().getFileName().toString();
        }
        throw new RuntimeException("Unable to retrieve filename");
    }

    public static OutputStream xmlOutputStream(String fileName, Path tempFile) throws IOException {
        OutputStream result = Files.newOutputStream(tempFile, new OpenOption[0]);
        try {
            if (YumMetadataUtils.isCompressedWithFormat(fileName, GZ)) {
                result = new GzipCompressorOutputStream(result);
            } else if (YumMetadataUtils.isCompressedWithFormat(fileName, XZ)) {
                result = new XZCompressorOutputStream(result);
            } else if (YumMetadataUtils.isCompressedWithFormat(fileName, BZIP)) {
                result = new BZip2CompressorOutputStream(result);
            }
        }
        catch (IOException ex) {
            result.close();
            throw ex;
        }
        return new BufferedOutputStream(result);
    }

    public static InputStream xmlInputStream(String fileName, InputStream primaryInputStream) throws IOException {
        InputStream result = primaryInputStream;
        if (YumMetadataUtils.isCompressedWithFormat(fileName, GZ)) {
            result = new GzipCompressorInputStream(primaryInputStream);
        } else if (YumMetadataUtils.isCompressedWithFormat(fileName, XZ)) {
            result = new XZCompressorInputStream(primaryInputStream);
        } else if (YumMetadataUtils.isCompressedWithFormat(fileName, BZIP)) {
            result = new BZip2CompressorInputStream(primaryInputStream);
        }
        return new BufferedInputStream(result);
    }

    private static boolean isCompressedWithFormat(String fileName, String format) {
        return fileName.endsWith(format);
    }
}

