/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.utils;

import com.google.common.base.Preconditions;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.sonatype.nexus.repository.yum.AssetKind;

public class AssetKindUtils {
    public static boolean isRpm(String filename) {
        int lastPeriodIndex = filename.lastIndexOf(46);
        if (lastPeriodIndex == -1 || lastPeriodIndex == filename.length() - 1) {
            return false;
        }
        String extension = filename.substring(lastPeriodIndex + 1);
        return "rpm".equalsIgnoreCase(extension) || "drpm".equalsIgnoreCase(extension);
    }

    public static boolean isRepomd(String filename) {
        return filename.equalsIgnoreCase("repomd.xml");
    }

    public static boolean isRepomdAsc(String filename) {
        return filename.equalsIgnoreCase("repomd.xml.asc");
    }

    public static boolean isComps(String filename) {
        return filename.equalsIgnoreCase("comps.xml");
    }

    public static boolean isModules(String filename) {
        Pattern matcher = Pattern.compile("modules\\..*[yY][aA][mM][lL]\\.?[gG]?[zZ]?");
        return matcher.matcher(filename).matches();
    }

    public static AssetKind detectKindByName(String filename) {
        Preconditions.checkNotNull((Object)filename);
        if (AssetKindUtils.isRpm(filename)) {
            return AssetKind.RPM;
        }
        if (AssetKindUtils.isComps(filename)) {
            return AssetKind.COMPS;
        }
        if (AssetKindUtils.isRepomd(filename)) {
            return AssetKind.REPOMD;
        }
        if (AssetKindUtils.isRepomdAsc(filename)) {
            return AssetKind.REPOMD_ASC;
        }
        if (AssetKindUtils.isModules(filename)) {
            return AssetKind.MODULES;
        }
        return AssetKind.NON_YUM;
    }

    public static AssetKind detectKindByPath(String path) {
        Preconditions.checkNotNull((Object)path);
        String filename = Paths.get(path, new String[0]).getFileName().toString();
        return AssetKindUtils.detectKindByName(filename);
    }
}

