/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.rpm;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmChangeLog;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmEntry;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmFile;

public class YumRpm {
    private String pkgId;
    private String location;
    private String checksum;
    private String checksumType;
    private String name;
    private String arch;
    private String epoch;
    private String version;
    private String release;
    private String summary;
    private String description;
    private String url;
    private Long timeFile;
    private Integer timeBuild;
    private String license;
    private String vendor;
    private String group;
    private String buildHost;
    private String sourceRpm;
    private Integer headerStart;
    private Integer headerEnd;
    private String packager;
    private Long sizePackage;
    private Integer sizeInstalled;
    private Integer sizeArchive;
    private List<YumRpmEntry> provides;
    private List<YumRpmEntry> requires;
    private List<YumRpmEntry> conflicts;
    private List<YumRpmEntry> obsoletes;
    private List<YumRpmFile> files;
    private List<YumRpmChangeLog> changes;

    public String getUniqueId() {
        return String.valueOf(this.name) + ":" + this.epoch + ":" + this.version + ":" + this.release;
    }

    public String getPkgId() {
        return this.pkgId;
    }

    public YumRpm setPkgId(String pkgId) {
        this.pkgId = pkgId;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public YumRpm setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public YumRpm setChecksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    public String getChecksumType() {
        return this.checksumType;
    }

    public YumRpm setChecksumType(String checksumType) {
        this.checksumType = checksumType;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public YumRpm setName(String name) {
        this.name = name;
        return this;
    }

    public String getArch() {
        return this.arch;
    }

    public YumRpm setArch(String arch) {
        this.arch = arch;
        return this;
    }

    public String getEpoch() {
        return this.epoch != null ? this.epoch : "0";
    }

    public YumRpm setEpoch(String epoch) {
        this.epoch = epoch;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public YumRpm setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getRelease() {
        return this.release;
    }

    public YumRpm setRelease(String release) {
        this.release = release;
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public YumRpm setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public YumRpm setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public YumRpm setUrl(String url) {
        this.url = url;
        return this;
    }

    public Long getTimeFile() {
        return this.timeFile;
    }

    public YumRpm setTimeFile(Long timeFile) {
        this.timeFile = timeFile;
        return this;
    }

    public Integer getTimeBuild() {
        return this.timeBuild;
    }

    public YumRpm setTimeBuild(Integer timeBuild) {
        this.timeBuild = timeBuild;
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public YumRpm setLicense(String license) {
        this.license = license;
        return this;
    }

    public String getVendor() {
        return this.vendor;
    }

    public YumRpm setVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public YumRpm setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getBuildHost() {
        return this.buildHost;
    }

    public YumRpm setBuildHost(String buildHost) {
        this.buildHost = buildHost;
        return this;
    }

    public String getSourceRpm() {
        return this.sourceRpm;
    }

    public YumRpm setSourceRpm(String sourceRpm) {
        this.sourceRpm = sourceRpm;
        return this;
    }

    public Integer getHeaderStart() {
        return this.headerStart;
    }

    public YumRpm setHeaderStart(Integer headerStart) {
        this.headerStart = headerStart;
        return this;
    }

    public Integer getHeaderEnd() {
        return this.headerEnd;
    }

    public YumRpm setHeaderEnd(Integer headerEnd) {
        this.headerEnd = headerEnd;
        return this;
    }

    public String getPackager() {
        return this.packager;
    }

    public YumRpm setPackager(String packager) {
        this.packager = packager;
        return this;
    }

    public Long getSizePackage() {
        return this.sizePackage;
    }

    public YumRpm setSizePackage(Long sizePackage) {
        this.sizePackage = sizePackage;
        return this;
    }

    public Integer getSizeInstalled() {
        return this.sizeInstalled;
    }

    public YumRpm setSizeInstalled(Integer sizeInstalled) {
        this.sizeInstalled = sizeInstalled;
        return this;
    }

    public Integer getSizeArchive() {
        return this.sizeArchive;
    }

    public YumRpm setSizeArchive(Integer sizeArchive) {
        this.sizeArchive = sizeArchive;
        return this;
    }

    public List<YumRpmEntry> getProvides() {
        if (this.provides == null) {
            return Collections.emptyList();
        }
        return this.provides;
    }

    public YumRpm setProvides(List<YumRpmEntry> provides) {
        this.provides = provides;
        return this;
    }

    public List<YumRpmEntry> getRequires() {
        if (this.requires == null) {
            return Collections.emptyList();
        }
        return this.requires;
    }

    public YumRpm setRequires(List<YumRpmEntry> requires) {
        this.requires = requires;
        return this;
    }

    public List<YumRpmEntry> getConflicts() {
        if (this.conflicts == null) {
            return Collections.emptyList();
        }
        return this.conflicts;
    }

    public YumRpm setConflicts(List<YumRpmEntry> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    public List<YumRpmEntry> getObsoletes() {
        if (this.obsoletes == null) {
            return Collections.emptyList();
        }
        return this.obsoletes;
    }

    public YumRpm setObsoletes(List<YumRpmEntry> obsoletes) {
        this.obsoletes = obsoletes;
        return this;
    }

    public List<YumRpmFile> getFiles() {
        if (this.files == null) {
            return Collections.emptyList();
        }
        return this.files;
    }

    public YumRpm setFiles(List<YumRpmFile> files) {
        this.files = files;
        return this;
    }

    public List<YumRpmChangeLog> getChanges() {
        if (this.changes == null) {
            return Collections.emptyList();
        }
        return this.changes;
    }

    public YumRpm setChanges(List<YumRpmChangeLog> changes) {
        this.changes = changes;
        return this;
    }

    public String getFullVersion() {
        return StringUtils.isNotBlank((String)this.getRelease()) ? String.valueOf(this.getVersion()) + "-" + this.getRelease() : this.getVersion();
    }

    public static enum FileType {
        FILE,
        DIR,
        GHOST;

    }
}

