/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.rpm;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.redline_rpm.header.AbstractHeader;

public class RedlineHeader {
    private final AbstractHeader header;

    public RedlineHeader(AbstractHeader header) {
        this.header = header;
    }

    @Nullable
    public String asString(AbstractHeader.Tag tag) {
        Object o = this.firstValue(tag);
        return o != null ? String.valueOf(o) : null;
    }

    public int asInt(AbstractHeader.Tag tag) {
        Object o = this.firstValue(tag);
        return o != null ? (Integer)o : 0;
    }

    @Nullable
    private Object firstValue(AbstractHeader.Tag tag) {
        AbstractHeader.Entry entry = this.header.getEntry(tag);
        if (entry != null && entry.getValues() != null) {
            return Array.get(entry.getValues(), 0);
        }
        return null;
    }

    public List<String> getStringList(AbstractHeader.Tag tag) {
        AbstractHeader.Entry entry = this.header.getEntry(tag);
        if (entry != null && entry.getValues() != null) {
            return Arrays.asList((String[])entry.getValues());
        }
        return Collections.emptyList();
    }

    public List<Integer> getIntegerList(AbstractHeader.Tag tag) {
        AbstractHeader.Entry entry = this.header.getEntry(tag);
        if (entry != null && entry.getValues() != null) {
            return Ints.asList((int[])((int[])entry.getValues()));
        }
        return Collections.emptyList();
    }

    public List<Short> getShortList(AbstractHeader.Tag tag) {
        AbstractHeader.Entry entry = this.header.getEntry(tag);
        if (entry != null && entry.getValues() != null) {
            return Shorts.asList((short[])((short[])entry.getValues()));
        }
        return Collections.emptyList();
    }
}

