/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import org.sonatype.nexus.repository.yum.AssetKind;

public enum YumMetadataType {
    PRIMARY(AssetKind.REPODATA, "xml.gz", "primary"),
    FILELISTS(AssetKind.REPODATA, "xml.gz", "filelists"),
    OTHER(AssetKind.REPODATA, "xml.gz", "other"),
    COMPS(AssetKind.REPODATA, "xml", "group"),
    COMPS_GZ(AssetKind.REPODATA, "xml.gz", "group_gz"),
    REPOMD(AssetKind.REPOMD, "xml", "repomd");

    private final AssetKind kind;
    private final String fileType;
    private final String type;

    private YumMetadataType(AssetKind kind, String fileType, String type) {
        this.kind = kind;
        this.fileType = fileType;
        this.type = type;
    }

    public AssetKind getKind() {
        return this.kind;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String lowerName() {
        return this.name().toLowerCase();
    }

    public String getType() {
        return this.type;
    }

    public static class Types {
        public static final String PRIMARY_TYPE = "primary";
        public static final String FILELISTS_TYPE = "filelists";
        public static final String OTHER_TYPE = "other";
        public static final String COMPS_TYPE = "group";
        public static final String COMPS_GZ_TYPE = "group_gz";
        public static final String REPOMD_TYPE = "repomd";
        public static final String UPDATELISTS_TYPE = "updatelists";

        private Types() {
        }
    }
}

