/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class RepomdChecksumAndSizeUpdater
extends ComponentSupport {
    protected static final String CHECKSUM = "repomd/data[@type='primary']/checksum/text()";
    protected static final String SIZE = "repomd/data[@type='primary']/size/text()";
    protected static final String OPEN_CHECKSUM = "repomd/data[@type='primary']/open-checksum/text()";
    protected static final String OPEN_SIZE = "repomd/data[@type='primary']/open-size/text()";
    protected static final String YUM_KEY = "yum";

    public void update(Document repomdXml, YumMetadata primaryMetadata, @Nullable Content primaryXml) {
        if (primaryXml != null) {
            Map attributes = this.getAttributes(primaryXml);
            if (this.isPrimaryXmlModified(attributes)) {
                this.updateElement(CHECKSUM, repomdXml, this.getChecksum(primaryMetadata, primaryXml));
                this.updateElement(SIZE, repomdXml, this.getSize(primaryXml));
                this.updateElement(OPEN_CHECKSUM, repomdXml, this.openChecksum(primaryMetadata, attributes));
                this.updateElement(OPEN_SIZE, repomdXml, this.openSize(attributes));
            }
        } else {
            this.log.warn("Unable to update checksum and size for primary file because primary could not be retrieved: {}", (Object)primaryMetadata.getLocation());
        }
    }

    protected abstract String getSize(Content var1);

    protected abstract Map getAttributes(Content var1);

    protected abstract String getChecksum(YumMetadata var1, Content var2);

    @Nullable
    protected String openChecksum(YumMetadata primaryMetadata, Map attributes) {
        String openChecksumType = primaryMetadata.getOpenChecksum();
        return this.openAttributeFor(openChecksumType, attributes);
    }

    @Nullable
    protected String openSize(Map attributes) {
        return this.openAttributeFor("size", attributes);
    }

    @Nullable
    protected String openAttributeFor(String key, Map attributes) {
        return Optional.ofNullable(attributes.get("open-" + key)).map(Objects::toString).orElse(null);
    }

    private boolean isPrimaryXmlModified(Map attributes) {
        return attributes.get("modified") != null;
    }

    private void updateElement(String expression, Document document, @Nullable String value) {
        if (value != null) {
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node element = (Node)xPath.evaluate(expression, document, XPathConstants.NODE);
                if (element != null) {
                    element.setNodeValue(value);
                }
            }
            catch (XPathExpressionException e) {
                this.log.error("Unable to update repomd xml", (Throwable)e);
            }
        }
    }
}

