/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.util.Map;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class CompressedTempBlob
implements AutoCloseable {
    private final TempBlob tempBlob;
    private final long decompressedSize;
    private final Map<HashAlgorithm, HashCode> decompressedHashes;
    private final boolean modified;

    public CompressedTempBlob(TempBlob tempBlob, long decompressedSize, Map<HashAlgorithm, HashCode> decompressedHashes, boolean modified) {
        this.tempBlob = (TempBlob)Preconditions.checkNotNull((Object)tempBlob);
        this.decompressedSize = (Long)Preconditions.checkNotNull((Object)decompressedSize);
        this.decompressedHashes = (Map)Preconditions.checkNotNull(decompressedHashes);
        this.modified = (Boolean)Preconditions.checkNotNull((Object)modified);
    }

    public long getDecompressedSize() {
        return this.decompressedSize;
    }

    public Map<HashAlgorithm, HashCode> getDecompressedHashes() {
        return this.decompressedHashes;
    }

    public TempBlob getTempBlob() {
        return this.tempBlob;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void close() {
        this.tempBlob.close();
    }
}

