/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMergeService;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMetadataMerger;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMetadataMergerFactory;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;

@Named
@Singleton
public class YumMergeServiceImpl
extends ComponentSupport
implements YumMergeService {
    private final YumMetadataMergerFactory mergers;

    @Inject
    public YumMergeServiceImpl(YumMetadataMergerFactory mergers) {
        Preconditions.checkNotNull((Object)mergers);
        this.mergers = mergers;
    }

    @Override
    public void merge(YumMetadataType yumMetadataType, OutputStream resultStream, List<InputStreamSupplier> streamsToMerge) {
        Preconditions.checkNotNull((Object)((Object)yumMetadataType));
        Preconditions.checkNotNull((Object)resultStream);
        Preconditions.checkNotNull(streamsToMerge);
        Preconditions.checkArgument((!streamsToMerge.isEmpty() ? 1 : 0) != 0);
        try {
            YumMetadataMerger yumMetadataMerger = this.getYumMetadataMerger(yumMetadataType);
            this.generateMergedFile(resultStream, yumMetadataMerger, streamsToMerge);
        }
        catch (IOException e) {
            this.log.warn("Unable to merge metadata for {}", (Object)yumMetadataType.getType(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private YumMetadataMerger getYumMetadataMerger(YumMetadataType yumMetadataType) {
        YumMetadataMerger yumMetadataMerger = this.mergers.getMetadataMerger(yumMetadataType.getType());
        Preconditions.checkNotNull((Object)yumMetadataMerger);
        return yumMetadataMerger;
    }

    private void generateMergedFile(OutputStream outputStream, YumMetadataMerger yumMetadataMerger, List<InputStreamSupplier> streamsToMerge) throws IOException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedOutputStream tempFileOutputStream = new BufferedOutputStream(outputStream);){
                yumMetadataMerger.merge(tempFileOutputStream, streamsToMerge);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XMLStreamException e) {
            this.log.warn("Unable to process xml data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

