/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.events.XMLEvent;

abstract class XmlBlockDeduper {
    private Set<String> uniqueBlockIds = new HashSet<String>();
    private final String blockIdentifier;

    public XmlBlockDeduper(String blockIdentifier) {
        Preconditions.checkNotNull((Object)blockIdentifier);
        this.blockIdentifier = blockIdentifier;
    }

    public abstract boolean isUnique(List<XMLEvent> var1);

    public void clear() {
        this.uniqueBlockIds.clear();
    }

    public boolean addIfBlockUnique(String id) {
        return this.uniqueBlockIds.add(id);
    }

    public boolean isBlockStart(XMLEvent event) {
        return event.isStartElement() && this.blockIdentifier.equals(event.asStartElement().getName().getLocalPart());
    }

    public boolean isBlockEnd(XMLEvent event) {
        return event.isEndElement() && this.blockIdentifier.equals(event.asEndElement().getName().getLocalPart());
    }

    public int uniqueBlockCount() {
        return this.uniqueBlockIds.size();
    }

    public XMLEvent process(XMLEvent xmlEvent) {
        return xmlEvent;
    }

    public void postProcess(XMLEventWriter xmlEventWriter) {
    }
}

