/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.gpg;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.security.GpgUtils;
import org.sonatype.nexus.repository.yum.internal.gpg.YumSigningFacet;

public abstract class AbstractSignaturesCleaner
implements EventAware,
EventAware.Asynchronous {
    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        repository.optionalFacet(YumSigningFacet.class).ifPresent(signingFacet -> {
            GpgUtils.SigningConfig newConfig = signingFacet.readSigningConfig(repository.getConfiguration());
            GpgUtils.SigningConfig oldConfig = signingFacet.readSigningConfig(event.getOldConfiguration());
            if (!Objects.equals(oldConfig, newConfig)) {
                this.deleteSignatures(repository);
            }
        });
    }

    protected abstract void deleteSignatures(Repository var1);
}

