/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.yum.internal.createrepo.FilesMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmEntry;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmFile;

public class PrimaryMetadataWriter
extends FilesMetadataWriter {
    private static final String LIBC = "libc.so.6";

    public PrimaryMetadataWriter(OutputStream out) throws XMLStreamException {
        super(out);
    }

    @Override
    protected void startMetadata(int numberOfPackages) throws XMLStreamException {
        this.writer.setPrefix("rpm", "http://linux.duke.edu/metadata/rpm");
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("metadata");
        this.writer.writeAttribute("xmlns", "http://linux.duke.edu/metadata/common");
        this.writer.writeAttribute("xmlns:rpm", "http://linux.duke.edu/metadata/rpm");
        this.writer.writeAttribute("packages", Integer.toString(numberOfPackages));
    }

    @Override
    public void append(YumRpm rpm) throws XMLStreamException {
        this.writer.writeStartElement("package");
        this.writer.writeAttribute("type", "rpm");
        this.writeBase(rpm);
        this.writeFormat(rpm);
        this.writer.writeEndElement();
    }

    private void writeBase(YumRpm rpm) throws XMLStreamException {
        this.writeElement("name", rpm.getName());
        this.writeElement("arch", rpm.getArch());
        this.writeElement("version", null, (Map<String, Object>)ImmutableMap.of((Object)"epoch", (Object)rpm.getEpoch(), (Object)"ver", (Object)rpm.getVersion(), (Object)"rel", (Object)rpm.getRelease()));
        this.writeElement("checksum", (Object)rpm.getChecksum(), (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)rpm.getChecksumType(), (Object)"pkgid", (Object)"YES"));
        this.writeElement("summary", rpm.getSummary());
        this.writeElement("description", rpm.getDescription());
        this.writeElement("packager", rpm.getPackager());
        this.writeElement("url", rpm.getUrl());
        this.writeElement("time", null, (Map<String, Object>)ImmutableMap.of((Object)"file", (Object)rpm.getTimeFile(), (Object)"build", (Object)rpm.getTimeBuild()));
        this.writeElement("size", null, (Map<String, Object>)ImmutableMap.of((Object)"package", (Object)rpm.getSizePackage(), (Object)"installed", (Object)rpm.getSizeInstalled(), (Object)"archive", (Object)rpm.getSizeArchive()));
        this.writeElement("location", null, (Map<String, Object>)ImmutableMap.of((Object)"href", (Object)rpm.getLocation()));
    }

    private void writeFormat(YumRpm rpm) throws XMLStreamException {
        this.writer.writeStartElement("format");
        this.writeElement("rpm", "license", rpm.getLicense());
        this.writeElement("rpm", "vendor", rpm.getVendor());
        this.writeElement("rpm", "group", rpm.getGroup());
        this.writeElement("rpm", "buildhost", rpm.getBuildHost());
        this.writeElement("rpm", "sourcerpm", rpm.getSourceRpm());
        this.writeElement("rpm", "header-range", null, (Map<String, Object>)ImmutableMap.of((Object)"start", (Object)rpm.getHeaderStart(), (Object)"end", (Object)rpm.getHeaderEnd()));
        this.writePRCO(rpm.getProvides(), "provides");
        this.writePRCO(this.collapseLibcRequires(rpm.getRequires()), "requires");
        this.writePRCO(rpm.getConflicts(), "conflicts");
        this.writePRCO(rpm.getObsoletes(), "obsoletes");
        this.writeFiles(rpm.getFiles(), YumRpmFile::isPrimary);
        this.writer.writeEndElement();
    }

    private void writePRCO(List<YumRpmEntry> entries, String type) throws XMLStreamException {
        if (entries != null && !entries.isEmpty()) {
            this.writer.writeStartElement("rpm:" + type);
            LinkedHashSet dedupedEntries = Sets.newLinkedHashSet(entries);
            for (YumRpmEntry entry : dedupedEntries) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("name", entry.getName());
                attributes.put("flags", entry.getFlags());
                attributes.put("epoch", this.epoch(entry));
                if (entry.isPre()) {
                    attributes.put("pre", "1");
                }
                attributes.put("ver", entry.getVersion());
                attributes.put("rel", entry.getRelease());
                this.writeElement("rpm:entry", null, attributes);
            }
            this.writer.writeEndElement();
        }
    }

    private String epoch(YumRpmEntry entry) {
        return entry.getEpoch() == null && entry.getVersion() != null ? "0" : entry.getEpoch();
    }

    private List<YumRpmEntry> collapseLibcRequires(List<YumRpmEntry> requires) {
        Optional<YumRpmEntry> best = requires.stream().filter(e -> e.getName().startsWith(LIBC)).sorted(new LibcVersionComparator()).findFirst();
        return requires.stream().filter(e -> !best.isPresent() || !e.getName().startsWith(LIBC) || e.equals(best.get())).collect(Collectors.toList());
    }

    private static class LibcVersionComparator
    implements Comparator<YumRpmEntry> {
        private VersionComparator versionComparator = new VersionComparator();

        LibcVersionComparator() {
        }

        @Override
        public int compare(YumRpmEntry o1, YumRpmEntry o2) {
            String v1 = this.version(o1.getName());
            String v2 = this.version(o2.getName());
            return this.versionComparator.compare(v2, v1);
        }

        private String version(String name) {
            return name.contains("libc.so.6(GLIBC_") ? name.substring(16, name.indexOf(41)) : "0";
        }
    }
}

