/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal;

import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowseNodeFilter;

@Singleton
@Named(value="yum")
public class YumBrowseNodeFilter
implements BrowseNodeFilter {
    private final Pattern metadataPath = Pattern.compile("(^|(.+\\/))repodata\\/[^\\/]*\\.xml[^\\/]*");

    public boolean test(BrowseNode node, Boolean isLocal) {
        if (node.getAssetId() == null) {
            return true;
        }
        String path = StringUtils.removeStart((String)node.getPath(), (String)"/");
        return isLocal != false || !this.metadataPath.matcher(path).matches();
    }
}

