/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;

@Named
@Singleton
public class YumAssetAttributePopulator
extends ComponentSupport {
    public Map<String, Object> extractAssetAttributes(YumRpm rpm) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("architecture", rpm.getArch());
        attributes.put("package_id", rpm.getPkgId());
        attributes.put("location", rpm.getLocation());
        attributes.put("checksum", rpm.getChecksum());
        attributes.put("checksum_type", rpm.getChecksumType());
        attributes.put("name", rpm.getName());
        attributes.put("epoch", rpm.getEpoch());
        attributes.put("version", rpm.getVersion());
        attributes.put("release", rpm.getRelease());
        attributes.put("description", rpm.getDescription());
        attributes.put("url", rpm.getUrl());
        attributes.put("time_file", rpm.getTimeFile());
        attributes.put("time_build", rpm.getTimeBuild());
        attributes.put("license", rpm.getLicense());
        attributes.put("vendor", rpm.getVendor());
        attributes.put("group", rpm.getGroup());
        attributes.put("build_host", rpm.getBuildHost());
        attributes.put("source", rpm.getSourceRpm());
        attributes.put("header_start", rpm.getHeaderStart());
        attributes.put("header_end", rpm.getHeaderEnd());
        attributes.put("packager", rpm.getPackager());
        attributes.put("size_package", rpm.getSizePackage());
        attributes.put("size_installed", rpm.getSizeInstalled());
        attributes.put("size_archive", rpm.getSizeArchive());
        return attributes;
    }

    public void populate(NestedAttributesMap attributes, YumRpm rpm) {
        Map<String, Object> rpmMap = this.extractAssetAttributes(rpm);
        rpmMap.forEach((key, value) -> {
            Object object = attributes.set(key, value);
        });
    }
}

