/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.metadata;

import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdChecksumAndSizeUpdater;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.utils.YumFacetUtils;

@Named
@Singleton
public class DataStoreRepomdChecksumAndSizeUpdater
extends RepomdChecksumAndSizeUpdater {
    private static final RuntimeException NO_BLOB_EXCEPTION = new RuntimeException("Unable to perform operation, no blob found.");

    @Override
    @Nullable
    protected String getChecksum(YumMetadata yumMetadata, Content primaryXml) {
        if (yumMetadata.getChecksum() != null) {
            return this.asset(primaryXml).blob().map(assetBlob -> (String)assetBlob.checksums().get(YumFacetUtils.hashAlgorithmByName(yumMetadata.getChecksum()).name())).orElseThrow(() -> NO_BLOB_EXCEPTION);
        }
        return null;
    }

    @Override
    protected String getSize(Content primaryXml) {
        return this.asset(primaryXml).blob().map(AssetBlob::blobSize).map(String::valueOf).orElseThrow(() -> NO_BLOB_EXCEPTION);
    }

    @Override
    protected Map getAttributes(Content primaryXml) {
        return (Map)this.asset(primaryXml).attributes().get("yum", Map.class);
    }

    private FluentAsset asset(Content primaryXml) {
        return (FluentAsset)primaryXml.getAttributes().get("org.sonatype.nexus.repository.content.Asset", FluentAsset.class);
    }
}

