/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.yum.datastore.internal.database.YumQueryGroupComponent;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdInvalidatorFacet;

@Named
@Facet.Exposed
public class YumGroupRepomdInvalidatorFacetImpl
extends FacetSupport
implements YumGroupRepomdInvalidatorFacet,
EventAware.Asynchronous {
    private final YumQueryGroupComponent yumQueryGroupComponent;

    @Inject
    public YumGroupRepomdInvalidatorFacetImpl(YumQueryGroupComponent yumQueryGroupComponent) {
        this.yumQueryGroupComponent = (YumQueryGroupComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryGroupComponent)));
    }

    @Override
    public void markRepomdAssetsToInvalidateCache() {
        this.yumQueryGroupComponent.findRepomdOnPath(this.getRepository(), "repodata/repomd.xml").ifPresent(asset -> FormatAttributesUtils.setFormatAttributes((FluentAsset)asset, (String)"cache_invalid", (Object)true));
    }

    @Override
    public void markRepomdAssetToUseCache(String path) {
        this.yumQueryGroupComponent.findRepomdOnPath(this.getRepository(), path).ifPresent(asset -> FormatAttributesUtils.removeFormatAttributes((FluentAsset)asset, (String)"cache_invalid"));
    }

    @Override
    public void markRepomdAssetToInvalidateCache(String assetPath) {
        Optional<FluentAsset> repomd = this.yumQueryGroupComponent.findRepomdOnPath(this.getRepository(), assetPath);
        repomd.ifPresent(asset -> FormatAttributesUtils.setFormatAttributes((FluentAsset)asset, (String)"cache_invalid", (Object)true));
    }

    @Subscribe
    @AllowConcurrentEvents
    protected void on(AssetDeletedEvent event) {
        if (this.isRelevantRepomdDeleteEvent(event)) {
            Repository repository = this.getRepository();
            String assetPath = event.getAsset().path();
            this.log.debug("Asset {} of Repository {} was deleted. Group Repository {} asset will be marked to have invalid cache.", new Object[]{assetPath, event.getRepository().map(Repository::getName).orElse(null), repository.getName()});
            this.markRepomdAssetToInvalidateCache(assetPath);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    protected void on(RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        if (this.isYumGroupRepository(repository)) {
            this.log.debug("Repository {} was updated. Marking Repomds to have invalid cache.", (Object)repository.getName());
            this.markRepomdAssetsToInvalidateCache();
        }
    }

    private boolean isYumGroupRepository(Repository repository) {
        return "group".equals(repository.getType().getValue()) && "yum".equals(repository.getFormat().getValue());
    }

    private boolean isRelevantRepomdDeleteEvent(AssetDeletedEvent event) {
        if (!event.getAsset().component().isPresent() && event.getAsset().path().endsWith("repodata/repomd.xml")) {
            if (event.getRepository().map(Repository::getName).map(arg_0 -> ((GroupFacet)((GroupFacet)this.facet(GroupFacet.class))).member(arg_0)).orElse(false).booleanValue()) {
                return true;
            }
        }
        return false;
    }
}

