/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.group;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.database.YumQueryGroupComponent;
import org.sonatype.nexus.repository.yum.datastore.internal.group.YumGroupRepomdInvalidatorFacetImpl;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupFacet;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupMerger;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdCreator;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdInvalidatorFacet;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdParser;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRequest;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class YumGroupFacetImpl
extends GroupFacetImpl
implements YumGroupFacet {
    private final YumGroupRepomdCreator groupRepomdCreator;
    private final YumGroupMerger groupMerger;
    private final YumGroupRepomdParser groupRepomdParser;
    private final YumQueryGroupComponent yumQueryGroupComponent;
    private YumContentFacet yumFacet;
    private YumGroupRepomdInvalidatorFacet yumGroupRepomdInvalidatorFacet;
    private Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 repomdCooperation;

    @Inject
    public YumGroupFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType, YumGroupRepomdCreator groupRepomdCreator, YumGroupMerger groupMerger, YumGroupRepomdParser groupRepomdParser, YumQueryGroupComponent yumQueryGroupComponent, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
        this.groupRepomdCreator = (YumGroupRepomdCreator)Preconditions.checkNotNull((Object)groupRepomdCreator);
        this.groupMerger = (YumGroupMerger)Preconditions.checkNotNull((Object)groupMerger);
        this.groupRepomdParser = (YumGroupRepomdParser)Preconditions.checkNotNull((Object)groupRepomdParser);
        this.yumQueryGroupComponent = (YumQueryGroupComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryGroupComponent)));
    }

    @Inject
    protected void configureCooperation(Cooperation2Factory cooperationFactory, @Named(value="${nexus.repomd.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.repomd.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.repomd.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.repomd.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.cooperationBuilder = cooperationFactory.configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    @VisibleForTesting
    void buildCooperation() {
        if (this.cooperationBuilder != null) {
            this.repomdCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":repomd");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.yumFacet = (YumContentFacet)this.facet(YumContentFacet.class);
        this.yumGroupRepomdInvalidatorFacet = (YumGroupRepomdInvalidatorFacet)this.facet(YumGroupRepomdInvalidatorFacetImpl.class);
        this.buildCooperation();
    }

    @Override
    @Nullable
    public Content buildRepomd(String path, Map<Repository, InputStreamSupplier> repositoriesResponseMap, Context context) {
        String requestPath = this.getRequestPath(context);
        try {
            return (Content)this.repomdCooperation.on(() -> this.buildMergedRepomd(path, repositoriesResponseMap, context)).checkFunction(() -> Optional.ofNullable(this.get(requestPath))).cooperate(requestPath, new String[0]);
        }
        catch (IOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{requestPath, context.getRepository().getName(), e});
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    protected Content buildMergedRepomd(String path, Map<Repository, InputStreamSupplier> repositoriesResponseMap, Context context) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(repositoriesResponseMap);
        Preconditions.checkNotNull((Object)context);
        if (repositoriesResponseMap.isEmpty()) {
            this.log.debug("Unable to create metadata for repository {}. Members had no metadata to merge.", (Object)context.getRepository().getName());
            return null;
        }
        this.log.info("Creating latest metadata by merging metadata of group members for repository {}", (Object)context.getRepository().getName());
        List<YumMetadataFile> metadataCollection = Collections.emptyList();
        Map<YumMetadataType, List<YumGroupRequest>> repodataFiles = this.groupRepomdParser.parse(repositoriesResponseMap);
        try {
            String repodataPath;
            Content content;
            metadataCollection = this.groupMerger.fetchAndMergeMetadata(path, repodataFiles, context);
            YumMetadataFile repomdFile = this.groupRepomdCreator.create(metadataCollection);
            if (repomdFile != null) {
                metadataCollection.add(repomdFile);
            }
            if (Objects.nonNull(content = this.saveAllAndDiscardUnused(metadataCollection, repodataPath = StringUtils.prependIfMissing((String)YumPathUtils.getRepodataPath(path), (CharSequence)"/", (CharSequence[])new CharSequence[0])))) {
                this.yumGroupRepomdInvalidatorFacet.markRepomdAssetToUseCache(path);
            }
            Content content2 = content;
            return content2;
        }
        finally {
            this.cleanupFiles(metadataCollection);
        }
    }

    @Override
    @Nullable
    public Content get(String requestPath) {
        return this.yumFacet.get(requestPath).map(FluentAsset::download).orElse(null);
    }

    public List<Repository> leafMembers() {
        List repositories = super.leafMembers();
        repositories.add(0, this.getRepository());
        return repositories;
    }

    @Nullable
    private Content saveAllAndDiscardUnused(List<YumMetadataFile> metadataCollection, String path) {
        ArrayList currentMetadata = Lists.newArrayList(this.retrieveCurrentMetadata(path));
        List<FluentAsset> savedAssets = this.saveMetadata(metadataCollection, path);
        this.discardUnusedMetadata(currentMetadata, savedAssets);
        return this.yumFacet.get(YumPathUtils.appendPath(path, "repomd.xml")).map(FluentAsset::download).orElse(null);
    }

    protected Iterable<FluentAsset> retrieveCurrentMetadata(String path) {
        return this.yumQueryGroupComponent.findMetadataByPathPrefix(path, this.getRepository());
    }

    private void discardUnusedMetadata(List<FluentAsset> currentMetadata, List<FluentAsset> newMetadata) {
        currentMetadata.stream().filter(metadata -> this.doesntExistIn((FluentAsset)metadata, newMetadata)).collect(Collectors.toList()).forEach(FluentAsset::delete);
    }

    private boolean doesntExistIn(FluentAsset currentMeta, List<FluentAsset> newMetadata) {
        return newMetadata.stream().noneMatch(newMeta -> newMeta.path().equals(currentMeta.path()));
    }

    private List<FluentAsset> saveMetadata(List<YumMetadataFile> metadataCollection, String path) {
        try {
            ArrayList<FluentAsset> savedAssets = new ArrayList<FluentAsset>();
            for (YumMetadataFile yumMetadataFile : metadataCollection) {
                FluentAsset asset = this.save(path, yumMetadataFile);
                savedAssets.add(asset);
            }
            return savedAssets;
        }
        catch (IOException e) {
            this.log.error("Unable to save metadata to {}", (Object)path, (Object)e);
            return Collections.emptyList();
        }
    }

    private void cleanupFiles(List<YumMetadataFile> metadataCollection) {
        metadataCollection.forEach(file -> {
            try {
                String filePath;
                Path path;
                if (Objects.nonNull(file) && Objects.nonNull(path = file.getPath()) && Objects.nonNull(filePath = path.toString()) && !filePath.isEmpty()) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                this.log.error("Unable to delete {}", (Object)file.getPath(), (Object)e);
            }
        });
    }

    private FluentAsset save(String path, YumMetadataFile yumGroupFile) throws IOException {
        YumMetadata yumMetadata = this.getYumMetadata(yumGroupFile);
        Content content = new Content((Payload)this.getStreamPayload(yumGroupFile, yumMetadata));
        return this.yumFacet.put(this.buildPath(path, yumMetadata), (Payload)content, yumGroupFile.getType().getKind());
    }

    private YumMetadata getYumMetadata(YumMetadataFile yumGroupFile) throws IOException {
        YumMetadata yumMetadata = yumGroupFile.getType() == YumMetadataType.REPOMD ? new YumMetadata(YumMetadataType.REPOMD) : YumMetadataUtils.readCompressedMetadata(yumGroupFile);
        return yumMetadata;
    }

    private StreamPayload getStreamPayload(YumMetadataFile yumGroupFile, YumMetadata yumMetadata) throws IOException {
        return new StreamPayload(() -> new BufferedInputStream(Files.newInputStream(yumGroupFile.getPath(), new OpenOption[0])), Files.size(yumGroupFile.getPath()), this.getContentType(yumMetadata));
    }

    private String getContentType(YumMetadataType yumMetadataType) {
        return yumMetadataType.getFileType().equals("xml") ? "application/xml" : "application/gzip";
    }

    private String getContentType(YumMetadata yumMetadata) {
        return this.getContentType(yumMetadata.getType());
    }

    private String buildPath(String basePath, YumMetadata yumMetadata) {
        String filename = this.getFilename(yumMetadata) + this.getExtension(yumMetadata);
        if (basePath.endsWith("/")) {
            return String.valueOf(basePath) + filename;
        }
        return String.valueOf(basePath) + "/" + filename;
    }

    private String getFilename(YumMetadata yumMetadata) {
        String type = yumMetadata.getType().getType();
        if (type.equals(YumMetadataType.COMPS.getType()) || type.equals(YumMetadataType.COMPS_GZ.getType())) {
            return "comps";
        }
        if (type.equals(YumMetadataType.REPOMD.getType())) {
            return type;
        }
        return String.valueOf(yumMetadata.getChecksum()) + "-" + type;
    }

    private String getExtension(YumMetadata yumMetadata) {
        return "." + yumMetadata.getType().getFileType();
    }

    private String getRequestPath(Context context) {
        return context.getRequest().getPath().substring(1);
    }
}

