/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.createrepo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.ContentBlobUtils;
import org.sonatype.nexus.repository.yum.datastore.internal.YumHostedFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.YumQueryComponent;
import org.sonatype.nexus.repository.yum.datastore.internal.createrepo.CreateRepoState;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoService;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.RepomdMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumDirectory;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.metadata.MetadataWriterFactory;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.internal.xmltools.AttributeXmlValueExtractor;
import org.sonatype.nexus.repository.yum.internal.xmltools.ElementXmlValueExtractor;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Named
@Singleton
public class CreateRepoServiceImpl
extends ComponentSupport
implements CreateRepoService {
    private static final String PACKAGE = "package";
    private static final String LOCATION = "location";
    private static final String LOCATION_ATTRIBUTE = "href";
    private static final String CHECKSUM = "checksum";
    private static final String REPOMD_PATH = "repodata/repomd.xml";
    private static final String COMPS_PATH = "repodata/comps.xml";
    private final Clock clock = new Clock();
    private final YumRpmParser rpmParser;
    private final YumQueryComponent queryComponent;

    @Inject
    public CreateRepoServiceImpl(YumRpmParser rpmParser, YumQueryComponent queryComponent) {
        this.rpmParser = rpmParser;
        this.queryComponent = queryComponent;
    }

    @Override
    public void buildMetadataWithoutCaching(Repository repository, Consumer<List<MetadataBlob>> updateListener) {
        this.buildMetadata(repository, false, updateListener, Collections.emptyList());
    }

    @Override
    public void buildMetadataUsingCaching(Repository repository, Consumer<List<MetadataBlob>> updateListener) {
        this.buildMetadata(repository, true, updateListener, Collections.emptyList());
    }

    @Override
    public void buildMetadataUsingCaching(Repository repository, Consumer<List<MetadataBlob>> updateListener, List<String> movedComponentIds) {
        List<Integer> componentIds = movedComponentIds.stream().map(Integer::valueOf).collect(Collectors.toList());
        this.buildMetadata(repository, true, updateListener, componentIds);
    }

    private void buildMetadata(Repository repository, boolean useCache, Consumer<List<MetadataBlob>> updateListener, List<Integer> movedComponentIds) {
        try {
            Integer repodataDepth = ((YumHostedFacet)repository.facet(YumHostedFacet.class)).getRepodataDepth();
            CreateRepoState createRepoState = new CreateRepoState(repository, repodataDepth, useCache);
            this.buildMetadata(createRepoState, updateListener, movedComponentIds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildMetadata(CreateRepoState state, Consumer<List<MetadataBlob>> updateListener, List<Integer> movedComponentIds) throws IOException, XMLStreamException {
        this.calculateDirectories(state, updateListener, movedComponentIds);
        if (state.getDirectories().size() == 0) {
            this.log.debug("Found no directories for metadata in {}", (Object)state.getRepository().getName());
            return;
        }
        try {
            this.convertDirectoriesToMetadata(state, updateListener, movedComponentIds);
        }
        finally {
            this.deleteTempFiles(state);
        }
    }

    private void convertDirectoriesToMetadata(CreateRepoState state, Consumer<List<MetadataBlob>> updateListener, List<Integer> movedComponentIds) throws IOException, XMLStreamException {
        for (YumDirectory directory : state.getDirectories()) {
            this.log.debug("Converting directory {} to metadata", (Object)directory.getPath());
            this.createWriters(state, directory);
            this.writeMetadata(state, directory, movedComponentIds);
            HashMap<YumMetadataType, YumMetadata> metadataDetails = new HashMap<YumMetadataType, YumMetadata>();
            this.writeRepomd(directory, state, metadataDetails);
            ArrayList<MetadataBlob> blobs = new ArrayList<MetadataBlob>(this.convertToMetadataBlobs(directory, metadataDetails));
            updateListener.accept(blobs);
        }
    }

    private List<MetadataBlob> convertToMetadataBlobs(YumDirectory directory, Map<YumMetadataType, YumMetadata> metadataDetails) {
        ArrayList<MetadataBlob> metadata = new ArrayList<MetadataBlob>();
        for (YumMetadataFile file : directory.getFiles()) {
            YumMetadataType type = file.getType();
            String path = this.buildPath(directory.getName(), type, metadataDetails.get((Object)type));
            String contentType = path.contains(".gz") ? "application/x-gzip" : "application/xml";
            metadata.add(new MetadataBlob(file.getPath(), path, contentType, type.getKind(), directory.getRpmCount()));
        }
        return metadata;
    }

    private String buildPath(String directoryName, YumMetadataType type, @Nullable YumMetadata yumMetadata) {
        String metadataName;
        if (type == YumMetadataType.REPOMD) {
            metadataName = REPOMD_PATH;
        } else {
            String checksum = yumMetadata != null ? yumMetadata.getChecksum() : "";
            metadataName = YumPathUtils.buildMetadataFilePath(checksum, type.lowerName());
        }
        String path = !directoryName.isEmpty() ? String.valueOf(directoryName) + "/" + metadataName : metadataName;
        return StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private void writeRepomd(YumDirectory directory, CreateRepoState state, Map<YumMetadataType, YumMetadata> metadataDetails) throws XMLStreamException, IOException {
        int startTimeInSeconds = (int)(this.clock.millis() / 1000L);
        this.log.debug("Building repomd.xml for repository {} and directory {}", (Object)state.getRepository().getName(), (Object)directory.getName());
        Path repomdXml = directory.getFiles().stream().filter(f -> f.getType() == YumMetadataType.REPOMD).findFirst().orElseThrow(() -> new RuntimeException("Repomd not found. Directory name " + directory.getName())).getPath();
        Throwable throwable = null;
        Object var7_8 = null;
        try (RepomdMetadataWriter repomdMetadataWriter = new RepomdMetadataWriter(Files.newOutputStream(repomdXml, new OpenOption[0]), startTimeInSeconds);){
            repomdMetadataWriter.startMetadata(directory.getFiles().size() - 1);
            this.readMetadataAndAppendToRepomd(directory, metadataDetails, repomdMetadataWriter);
            this.appendComps(state, repomdMetadataWriter, directory);
            repomdMetadataWriter.end();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendComps(CreateRepoState state, RepomdMetadataWriter repomdMetadataWriter, YumDirectory directory) throws XMLStreamException, IOException {
        this.log.debug("Searching for comps.xml to add to metadata for directory {}", (Object)directory.getName());
        String compsAssetPath = this.buildCompsPath(directory.getName());
        Iterable<FluentAsset> comps = this.queryComponent.findCompsByAssetPath(state.getRepository(), compsAssetPath);
        for (FluentAsset comp : comps) {
            YumMetadata compsMetadata;
            if (comp.path().contains("xml.gz")) {
                this.log.debug("Found compressed comps.xml: {}", (Object)comp.path());
                YumMetadataFile metadataFile = new YumMetadataFile(YumMetadataType.COMPS_GZ, Paths.get(comp.path(), new String[0]));
                Blob blob = ContentBlobUtils.getBlob(comp);
                compsMetadata = YumMetadataUtils.readCompressedMetadata(metadataFile, blob.getInputStream());
            } else {
                this.log.debug("Found uncompressed comps.xml: {}", (Object)comp.path());
                AssetBlob assetBlob = ContentBlobUtils.getAssetBlob(comp);
                String checksum = (String)assetBlob.checksums().get(HashAlgorithm.SHA256.name());
                long size = assetBlob.blobSize();
                compsMetadata = new YumMetadata(YumMetadataType.COMPS).setChecksum(checksum).setSize(size);
            }
            this.log.debug("Appending {} to repomd.xml for directory {}", (Object)comp.path(), (Object)directory.getName());
            repomdMetadataWriter.append(compsMetadata);
        }
    }

    private String buildCompsPath(@Nullable String directoryName) {
        String expectedPath = StringUtils.isNotBlank((CharSequence)directoryName) ? String.valueOf(directoryName) + "/" + COMPS_PATH : COMPS_PATH;
        return StringUtils.prependIfMissing((String)expectedPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private void readMetadataAndAppendToRepomd(YumDirectory directory, Map<YumMetadataType, YumMetadata> metadataDetails, RepomdMetadataWriter repomdMetadataWriter) throws IOException, XMLStreamException {
        for (YumMetadataFile file : directory.getFiles()) {
            if (file.getType() == YumMetadataType.REPOMD) continue;
            this.log.debug("Reading metadata file {} from directory {} to get checksums ", (Object)file.getPath(), (Object)directory.getName());
            YumMetadata metadata = YumMetadataUtils.readCompressedMetadata(file);
            metadataDetails.put(file.getType(), metadata);
            repomdMetadataWriter.append(metadata);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeMetadata(CreateRepoState state, YumDirectory directory, List<Integer> movedComponentIds) {
        this.log.debug("Writing non-repomd metadata for repository {} and directory {}", (Object)state.getRepository().getName(), (Object)directory.getName());
        try {
            try {
                for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                    writer.start((int)directory.getRpmCount());
                }
                if (directory.isUseCache()) {
                    this.log.debug("Directory {} is marked as use cache, appending metadata from existing cached files", (Object)directory.getName());
                    newRpms = new HashSet<String>();
                    for (FluentAsset rpm : this.browseNewRpms(state, directory)) {
                        newRpms.add(rpm.path());
                        this.appendRpm(state, directory, rpm);
                    }
                    for (FluentAsset rpm : this.findMovedRpms(state, directory, movedComponentIds)) {
                        if (newRpms.contains(rpm.path())) continue;
                        newRpms.add(rpm.path());
                        this.appendRpm(state, directory, rpm);
                    }
                    this.log.debug("Found {} new RPMs to be added", (Object)newRpms.size());
                    this.appendCachedEntries(state, directory, newRpms);
                } else {
                    this.loopAllRpmsAndAppend(state, directory);
                }
                for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                    writer.end();
                }
            }
            catch (IOException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ** for (writer : state.getWriters().values())
        }
lbl-1000:
        // 1 sources

        {
            writer.close();
            continue;
        }
lbl35:
        // 1 sources

    }

    private void appendCachedEntries(CreateRepoState state, YumDirectory directory, Set<String> newRpms) throws IOException, XMLStreamException {
        Map<YumMetadataType, FluentAsset> repodata = this.findRepodata(state, directory);
        if (!this.allMetadataExists(repodata)) {
            this.log.warn("A metadata file was deleted during metadata generation, falling back to non-cached method");
            this.loopAllRpmsAndAppend(state, directory);
            return;
        }
        MetadataWriter<YumRpm> primaryWriter = state.getWriters().get((Object)YumMetadataType.PRIMARY);
        FluentAsset primaryXml = repodata.get((Object)YumMetadataType.PRIMARY);
        Optional<Blob> primaryXmlBlob = ContentBlobUtils.getBlobOptional(primaryXml);
        if (primaryXmlBlob.isPresent()) {
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream xml = this.gzipIn(primaryXmlBlob.get().getInputStream());){
                Set<String> excludedChecksums = this.writeToPrimaryUsingCache(state, newRpms, primaryWriter, xml, directory);
                this.writeNonPrimaryFilesUsingCache(state, repodata, excludedChecksums);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void writeNonPrimaryFilesUsingCache(CreateRepoState state, Map<YumMetadataType, FluentAsset> repodata, Set<String> excludedChecksums) throws XMLStreamException, IOException {
        for (Map.Entry<YumMetadataType, MetadataWriter<YumRpm>> entry : state.getWriters().entrySet()) {
            YumMetadataType type = entry.getKey();
            if (type == YumMetadataType.PRIMARY) continue;
            MetadataWriter<YumRpm> writer = entry.getValue();
            FluentAsset asset = repodata.get((Object)type);
            if (asset == null) continue;
            Blob metadataXml = ContentBlobUtils.getBlob(asset);
            Throwable throwable = null;
            Object var11_12 = null;
            try (InputStream in = this.gzipIn(metadataXml.getInputStream());){
                writer.copyFromXml(in, PACKAGE, block -> {
                    String checksum = new AttributeXmlValueExtractor(PACKAGE, "pkgid").extract((Collection<XMLEvent>)block);
                    return !excludedChecksums.contains(checksum);
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private Set<String> writeToPrimaryUsingCache(CreateRepoState state, Set<String> addedRpms, MetadataWriter<YumRpm> primaryWriter, InputStream xml, YumDirectory directory) throws XMLStreamException {
        HashSet<String> excludedChecksums = new HashSet<String>();
        primaryWriter.copyFromXml(xml, PACKAGE, block -> {
            String location = new AttributeXmlValueExtractor(LOCATION, LOCATION_ATTRIBUTE).extract((Collection<XMLEvent>)block);
            if (location != null && !addedRpms.contains(location) && this.rpmExists(state, location, directory)) {
                return true;
            }
            String checksum = new ElementXmlValueExtractor(CHECKSUM).extract((Collection<XMLEvent>)block);
            if (checksum != null) {
                excludedChecksums.add(checksum);
            }
            return false;
        });
        return excludedChecksums;
    }

    private boolean rpmExists(CreateRepoState state, String location, YumDirectory directory) {
        String path = location;
        if (StringUtils.isNotBlank((CharSequence)directory.getName())) {
            path = String.valueOf(directory.getName()) + "/" + location;
        }
        String contentPath = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        Repository repository = state.getRepository();
        YumContentFacet facet = (YumContentFacet)repository.facet(YumContentFacet.class);
        return !directory.isRpmsRemoved() || facet.get(contentPath).isPresent();
    }

    private void loopAllRpmsAndAppend(CreateRepoState state, YumDirectory directory) throws IOException, XMLStreamException {
        for (FluentAsset asset : this.browseAllRpms(state, directory)) {
            this.appendRpm(state, directory, asset);
        }
    }

    private Iterable<FluentAsset> browseAllRpms(CreateRepoState state, YumDirectory directory) {
        String path = directory == null ? "" : directory.getPath();
        String contentPath = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return this.queryComponent.browseRpmsForPath(state.getRepository(), contentPath);
    }

    private Iterable<FluentAsset> findMovedRpms(CreateRepoState state, YumDirectory directory, List<Integer> componentIds) {
        String path = directory == null ? "" : directory.getPath();
        String contentPath = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return this.queryComponent.findAssetsByComponentIds(state.getRepository(), contentPath, componentIds);
    }

    private Iterable<FluentAsset> browseAllComps(CreateRepoState state, YumDirectory directory) {
        String path = directory == null ? "" : directory.getPath();
        String contentPath = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return this.queryComponent.browseCompsForPath(state.getRepository(), contentPath);
    }

    private boolean allMetadataExists(Map<YumMetadataType, FluentAsset> repodata) {
        return repodata.containsKey((Object)YumMetadataType.PRIMARY) && repodata.containsKey((Object)YumMetadataType.FILELISTS) && repodata.containsKey((Object)YumMetadataType.OTHER);
    }

    private Map<YumMetadataType, FluentAsset> findRepodata(CreateRepoState state, YumDirectory directory) {
        HashMap<YumMetadataType, FluentAsset> repodata = new HashMap<YumMetadataType, FluentAsset>();
        String repodataPath = YumPathUtils.repodataPath(directory);
        String contentRepodataPath = StringUtils.prependIfMissing((String)repodataPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        Iterable<FluentAsset> metadata = this.queryComponent.findRepodataAssetsOnPath(state.getRepository(), contentRepodataPath);
        for (FluentAsset metadataAsset : metadata) {
            if (metadataAsset.path().contains("primary.xml")) {
                repodata.put(YumMetadataType.PRIMARY, metadataAsset);
                continue;
            }
            if (metadataAsset.path().contains("filelists.xml")) {
                repodata.put(YumMetadataType.FILELISTS, metadataAsset);
                continue;
            }
            if (!metadataAsset.path().contains("other.xml")) continue;
            repodata.put(YumMetadataType.OTHER, metadataAsset);
        }
        return repodata;
    }

    private void appendRpm(CreateRepoState state, YumDirectory directory, FluentAsset asset) throws IOException, XMLStreamException {
        this.log.debug("Adding RPM {} to metadata for repository {} and directory {}", new Object[]{asset.path(), state.getRepository().getName(), directory.getName()});
        Optional<Blob> blob = ContentBlobUtils.getBlobOptional(asset);
        if (!blob.isPresent()) {
            this.log.warn("Excluding {} from the generated metadata because the blob could not be found", (Object)asset.path());
            return;
        }
        this.writeAssetToMetadata(state, asset, blob.get());
    }

    private void writeAssetToMetadata(CreateRepoState state, FluentAsset rpmAsset, @Nullable Blob blob) throws IOException, XMLStreamException {
        block11: {
            if (blob != null) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (InputStream in = blob.getInputStream();){
                    String assetPath = rpmAsset.path();
                    YumRpm rpm = this.rpmParser.parse(in, this.rpmLocationRelativeToDepth(assetPath, state.getRepodataDepth()));
                    for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                        writer.append(rpm);
                    }
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.log.warn("Excluding {} from the generated metadata because the blob could not be found", (Object)rpmAsset.path());
        }
    }

    private String rpmLocationRelativeToDepth(String assetPath, Integer repodataDepth) {
        assetPath = StringUtils.removeStart((String)assetPath, (String)"/");
        if (repodataDepth == 0) {
            return assetPath;
        }
        String rootDirectory = YumPathUtils.extractDirectoryAtDepth(assetPath, repodataDepth).orElse(assetPath);
        return assetPath.substring(rootDirectory.length() + 1);
    }

    private Iterable<FluentAsset> browseNewRpms(CreateRepoState state, @Nullable YumDirectory directory) {
        String path = directory == null ? "" : directory.getPath();
        String contentPath = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        long metadataGenerationStartedTime = ((YumHostedFacet)state.getRepository().facet(YumHostedFacet.class)).getMetadataGenerationStartedTime();
        return this.queryComponent.browseRpmBlobsUpdatedSince(state.getRepository(), contentPath, metadataGenerationStartedTime);
    }

    private Iterable<FluentAsset> browseNewComps(CreateRepoState state, @Nullable YumDirectory directory) {
        String path = directory == null ? "" : directory.getPath();
        String contentPath = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        long metadataGenerationStartedTime = ((YumHostedFacet)state.getRepository().facet(YumHostedFacet.class)).getMetadataGenerationStartedTime();
        return this.queryComponent.browseCompsBlobsUpdatedSince(state.getRepository(), contentPath, metadataGenerationStartedTime);
    }

    private void createWriters(CreateRepoState state, YumDirectory directory) throws IOException, XMLStreamException {
        for (YumMetadataFile file : directory.getFiles()) {
            MetadataWriter<YumRpm> writer;
            if (file.getType() == YumMetadataType.REPOMD || (writer = MetadataWriterFactory.getWriter(file)) == null) continue;
            state.putWriter(file.getType(), writer);
        }
    }

    private void calculateDirectories(CreateRepoState state, Consumer<List<MetadataBlob>> updateListener, List<Integer> movedComponentIds) throws IOException {
        this.log.debug("Calculating directories for generating Yum metadata for repository {}", (Object)state.getRepository().getName());
        long countRPMs = this.queryComponent.countRpmsInDirectory(state.getRepository(), null);
        long countComps = this.queryComponent.countCompsInDirectory(state.getRepository(), null);
        if (countRPMs == 0L && countComps == 0L && movedComponentIds.isEmpty()) {
            this.log.debug("Found no RPMs and Comps in repository: {}", (Object)state.getRepository().getName());
            updateListener.accept(Collections.emptyList());
            this.removeRpmsRemovedFlagsIfPresent(state.getRepository());
            return;
        }
        Integer repodataDepth = state.getRepodataDepth();
        if (repodataDepth == 0) {
            YumDirectory directory = new YumDirectory("");
            directory.setRpmCount(countRPMs);
            directory.setUseCache(this.useCachedMetadata(state, null));
            directory.setRpmsRemoved(this.haveRpmsBeenRemovedFromRoot(state.getRepository()));
            this.addFilesToDirectory(directory);
            state.addDirectory(directory);
            this.log.debug("Repo depth 0, using {}", (Object)directory);
        } else {
            this.deriveDirectoriesFromRpms(state, movedComponentIds);
        }
    }

    private void deriveDirectoriesFromRpms(CreateRepoState state, List<Integer> movedComponentIds) throws IOException {
        HashMap<String, YumDirectory> directories = new HashMap<String, YumDirectory>();
        this.calculateDirectoriesWithModifiedRpms(state, directories, movedComponentIds);
        this.calculateDirectoriesWithRemovedRpms(state, directories);
        for (YumDirectory directory : directories.values()) {
            this.addFilesToDirectory(directory);
            state.addDirectory(directory);
        }
    }

    private void calculateDirectoriesWithModifiedRpms(CreateRepoState state, Map<String, YumDirectory> directories, List<Integer> movedComponentIds) {
        this.browseRpmsForDirectoryCalculation(state, movedComponentIds).stream().map(Asset::path).forEach(assetPath -> {
            YumDirectory yumDirectory = this.deriveDirectoryForPath(state, directories, (String)assetPath);
        });
        this.log.debug("Calculated directories with modified RPMs: {}", directories);
    }

    @Nullable
    private YumDirectory deriveDirectoryForPath(CreateRepoState state, Map<String, YumDirectory> directories, String assetPath) {
        this.log.debug("Deriving directory for {}", (Object)assetPath);
        Optional<String> directoryName = YumPathUtils.extractDirectoryAtDepth(StringUtils.removeStart((String)assetPath, (String)"/"), state.getRepodataDepth());
        if (directoryName.isPresent()) {
            YumDirectory directory = directories.computeIfAbsent(directoryName.get(), path -> {
                YumDirectory computed = new YumDirectory((String)path);
                computed.setRpmCount(this.queryComponent.countRpmsInDirectory(state.getRepository(), (String)path));
                this.log.debug("Adding new directory {}", (Object)computed);
                return computed;
            });
            if (!directory.isUseCache() && this.useCachedMetadata(state, directory)) {
                this.log.debug("Setting use cached metadata for {}", (Object)directory);
                directory.setUseCache(true);
            }
            return directory;
        }
        this.log.warn("RPM ({}) found above the repodata depth {} while creating the Yum Metadata for {}. This is likely a result of the repodata depth being changed and this RPM will not be included in the metadata and should be removed from the repository.", new Object[]{assetPath, state.getRepodataDepth(), state.getRepository().getName()});
        return null;
    }

    private Collection<FluentAsset> browseRpmsForDirectoryCalculation(CreateRepoState state, List<Integer> movedComponentIds) {
        if (this.useCachedMetadata(state, null)) {
            return Stream.of(this.browseNewRpms(state, null), this.browseNewComps(state, null), this.findMovedRpms(state, null, movedComponentIds)).flatMap(Continuations::streamOf).collect(Collectors.toList());
        }
        return Stream.of(this.browseAllRpms(state, null), this.browseAllComps(state, null)).flatMap(Continuations::streamOf).collect(Collectors.toList());
    }

    private void calculateDirectoriesWithRemovedRpms(CreateRepoState state, Map<String, YumDirectory> directories) {
        for (String removedRpmPath : this.fetchRepomdPathsOfDeletedRpms(state)) {
            YumDirectory directory = this.deriveDirectoryForPath(state, directories, removedRpmPath);
            if (directory == null) continue;
            this.log.debug("Removed RPMs in {}", (Object)directory);
            directory.setRpmsRemoved(true);
        }
    }

    private Collection<String> fetchRepomdPathsOfDeletedRpms(CreateRepoState state) {
        Repository repository = state.getRepository();
        Collection<String> paths = this.queryComponent.getMetadataPathsThatHaveHadRpmsRemoved(repository);
        this.log.debug("Repomd paths of deleted RPMs in '{}' repository: {}", (Object)repository.getName(), paths);
        return paths;
    }

    private boolean useCachedMetadata(CreateRepoState state, @Nullable YumDirectory directory) {
        long metadataGenerationStartedTime = ((YumHostedFacet)state.getRepository().facet(YumHostedFacet.class)).getMetadataGenerationStartedTime();
        if (state.isUseCache() && metadataGenerationStartedTime > 0L) {
            if (directory == null && state.getRepodataDepth() > 0) {
                return true;
            }
            Map<YumMetadataType, FluentAsset> repodata = this.findRepodata(state, directory);
            return this.allMetadataExists(repodata);
        }
        return false;
    }

    private boolean haveRpmsBeenRemovedFromRoot(Repository repository) {
        return this.queryComponent.findRepomd(repository, null).filter(asset -> {
            Map formatAttributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)asset);
            return formatAttributes.getOrDefault("rpms_removed", false);
        }).isPresent();
    }

    private void addFilesToDirectory(YumDirectory directory) throws IOException {
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.FILELISTS, Files.createTempFile(YumMetadataType.FILELISTS.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.PRIMARY, Files.createTempFile(YumMetadataType.PRIMARY.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.OTHER, Files.createTempFile(YumMetadataType.OTHER.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.REPOMD, Files.createTempFile(YumMetadataType.REPOMD.lowerName(), "xml", new FileAttribute[0])));
    }

    private void removeRpmsRemovedFlagsIfPresent(Repository repository) {
        Collection<String> metadataPathsThatHaveHadRpmsRemoved = this.queryComponent.getMetadataPathsThatHaveHadRpmsRemoved(repository);
        YumHostedFacet yumHostedFacet = (YumHostedFacet)repository.facet(YumHostedFacet.class);
        for (String removedRpmPath : metadataPathsThatHaveHadRpmsRemoved) {
            yumHostedFacet.markMetadataAsRpmsRemoved(removedRpmPath, false);
            this.log.debug("Removed '{}' attribute from {}", (Object)"rpms_removed", (Object)removedRpmPath);
        }
    }

    private void deleteTempFiles(CreateRepoState state) {
        this.log.debug("Removing temp files used in Yum metadata generation");
        for (YumDirectory directory : state.getDirectories()) {
            for (YumMetadataFile file : directory.getFiles()) {
                try {
                    this.log.debug("Removing temporary Yum metadata file {}", (Object)file.getPath());
                    Files.delete(file.getPath());
                }
                catch (IOException e) {
                    this.log.error("Failed to delete temporary file {} during yum metadata creation", (Object)file.getPath(), (Object)e);
                }
            }
        }
    }

    private InputStream gzipIn(InputStream inputStream) throws IOException {
        return new GzipCompressorInputStream((InputStream)new BufferedInputStream(inputStream));
    }
}

