/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal.createrepo;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.datastore.internal.YumHostedFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoService;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.RpmRedeployedEvent;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumCleanupMetadataEvent;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataInvalidationEvent;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Named
public class CreateRepoFacetImpl
extends FacetSupport
implements CreateRepoFacet,
EventAware.Asynchronous {
    private final Clock clock = new Clock();
    private final long interval;
    private final long cleanUpInterval;
    private final boolean cachingEnabled;
    private final CreateRepoService createRepo;
    private final AtomicBoolean acceptingEvents = new AtomicBoolean(true);
    private final AtomicBoolean eventFired = new AtomicBoolean(false);
    private final AtomicBoolean isCleanupSleep = new AtomicBoolean(false);
    private final ListMultimap<String, String> deprecatedMetadataFiles = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    @Inject
    public CreateRepoFacetImpl(@Named(value="${nexus.yum.createrepo.interval:-60000}") long interval, @Named(value="${nexus.yum.createrepo.cleanUpInterval:-30000}") long cleanUpInterval, @Named(value="${nexus.yum.createrepo.caching:-true}") boolean cachingEnabled, CreateRepoService createRepo) {
        this.interval = interval;
        this.cleanUpInterval = cleanUpInterval;
        this.cachingEnabled = cachingEnabled;
        this.createRepo = createRepo;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent event) {
        if (this.matchesRepository((AssetEvent)event) && this.isEventRelevant((AssetEvent)event)) {
            this.invalidateMetadata();
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent event) {
        if (this.matchesRepository((AssetEvent)event) && this.isEventRelevant((AssetEvent)event)) {
            this.invalidateMetadata();
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(RpmRedeployedEvent event) {
        if (event.getRepositoryName().equals(this.getRepository().getName())) {
            this.invalidateMetadata();
        }
    }

    @Subscribe
    public void on(YumMetadataInvalidationEvent event) {
        if (event.getRepositoryName().equals(this.getRepository().getName())) {
            this.acceptingEvents.set(false);
            this.maybeWait(event);
            this.log.info("Rebuilding yum metadata for repository {}", (Object)this.getRepository().getName());
            this.acceptingEvents.set(true);
            this.eventFired.set(false);
            long startTime = this.clock.millis();
            this.buildMetadata(event, this::updateMetadata);
            ((YumHostedFacet)this.getRepository().facet(YumHostedFacet.class)).metadataGenerationStarted(startTime);
            this.log.info("Finished rebuilding yum metadata for repository {}", (Object)this.getRepository().getName());
        }
    }

    @Subscribe
    public void on(YumCleanupMetadataEvent event) {
        if (!event.getRepositoryName().equals(this.getRepository().getName())) {
            return;
        }
        this.deprecatedMetadataFiles.putAll((Object)this.getRepository().getName(), event.getDeprecatedMetadata());
        if (this.isCleanupSleep.get()) {
            return;
        }
        this.maybeWaitForCleanup();
        this.log.debug("Cleanup metadata is running for repository {}", (Object)this.getRepository().getName());
        ArrayList assetPathsToRemove = new ArrayList(this.deprecatedMetadataFiles.get((Object)this.getRepository().getName()));
        for (String assetPath : assetPathsToRemove) {
            ((YumContentFacet)this.facet(YumContentFacet.class)).get(assetPath).ifPresent(FluentAsset::delete);
        }
        this.log.debug("Finished cleanup metadata for repository {}", (Object)this.getRepository().getName());
        assetPathsToRemove.forEach(it -> {
            boolean bl = this.deprecatedMetadataFiles.remove((Object)this.getRepository().getName(), it);
        });
    }

    private void maybeWaitForCleanup() {
        if (this.cleanUpInterval <= 0L) {
            return;
        }
        this.isCleanupSleep.set(true);
        try {
            try {
                Thread.sleep(this.cleanUpInterval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("Yum clean up metadata thread interrupted");
                this.isCleanupSleep.set(false);
            }
        }
        finally {
            this.isCleanupSleep.set(false);
        }
    }

    @Override
    public synchronized void invalidateMetadata() {
        if (this.acceptingEvents.get() && !this.eventFired.get()) {
            this.log.info("Scheduling rebuild of yum metadata to start for repository {} in {} seconds", (Object)this.getRepository().getName(), (Object)(this.interval / 1000L));
            this.eventFired.set(true);
            this.getEventManager().post((Object)new YumMetadataInvalidationEvent(this.getRepository().getName(), true, true));
        } else {
            this.log.debug("Skipping metadata rebuild, another event already queued.");
        }
    }

    @Override
    public void invalidateMetadataWithoutWaiting(boolean useCache) {
        this.invalidateMetadataWithoutWaiting(useCache, Collections.emptyList());
    }

    @Override
    public void invalidateMetadataWithoutWaiting(boolean useCache, List<String> movedComponentIds) {
        this.eventFired.set(true);
        this.log.info("Invalidating of yum metadata without waiting with repository: {} additional components size: {}", (Object)this.getRepository().getName(), (Object)movedComponentIds.size());
        this.getEventManager().post((Object)new YumMetadataInvalidationEvent(this.getRepository().getName(), false, useCache, movedComponentIds));
    }

    protected void updateMetadata(List<MetadataBlob> metadataBlobs) {
        YumHostedFacet hosted = (YumHostedFacet)this.getRepository().facet(YumHostedFacet.class);
        List<String> excludeFromDelete = metadataBlobs.stream().map(MetadataBlob::getPath).collect(Collectors.toList());
        List<String> directoriesToDelete = metadataBlobs.stream().map(MetadataBlob::getPath).map(YumPathUtils::extractDirectoryFromMetadataPath).filter(path -> !path.isEmpty()).collect(Collectors.toList());
        if (metadataBlobs.isEmpty()) {
            hosted.deleteRepomd();
        }
        this.updateEachMetadataFile(metadataBlobs);
        this.markDirectoryModified(metadataBlobs);
        List<FluentAsset> metadataFilesToDelete = hosted.getMetadataFilesToDelete(directoriesToDelete, excludeFromDelete);
        this.deleteMetadataFilesIfNoRpmsLeft(metadataFilesToDelete);
        if (!metadataFilesToDelete.isEmpty()) {
            this.getEventManager().post((Object)new YumCleanupMetadataEvent(this.getRepository().getName(), metadataFilesToDelete.stream().map(Asset::path).collect(Collectors.toList())));
        }
    }

    private void deleteMetadataFilesIfNoRpmsLeft(List<FluentAsset> metadataFilesToDelete) {
        Set<String> directories = this.extractDirectories(metadataFilesToDelete);
        YumHostedFacet hosted = (YumHostedFacet)this.getRepository().facet(YumHostedFacet.class);
        for (String directory : directories) {
            hosted.deleteRepomdIfNoRpmsLeft(directory);
            hosted.deleteRepodataIfNoRpmsLeft(directory);
        }
    }

    private Set<String> extractDirectories(List<FluentAsset> metadataFilesToDelete) {
        return metadataFilesToDelete.stream().map(Asset::path).map(YumPathUtils::extractDirectoryFromMetadataPath).collect(Collectors.toSet());
    }

    private void updateEachMetadataFile(List<MetadataBlob> metadataBlobs) {
        MetadataBlob repoMdMetadataBlob = null;
        for (MetadataBlob metadataBlob : metadataBlobs) {
            if (metadataBlob.getAssetKind() == AssetKind.REPOMD) {
                repoMdMetadataBlob = metadataBlob;
                continue;
            }
            this.saveMetadata(metadataBlob);
        }
        this.saveRepoMd(repoMdMetadataBlob);
    }

    private void saveRepoMd(MetadataBlob repoMdMetadataBlob) {
        if (repoMdMetadataBlob != null) {
            this.log.debug("Saving RepoMd with path {}", (Object)repoMdMetadataBlob.getPath());
            this.saveMetadata(repoMdMetadataBlob);
        }
    }

    private void saveMetadata(MetadataBlob metadataBlob) {
        String contentType = metadataBlob.getPath().contains(".gz") ? "application/x-gzip" : "application/xml";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StreamPayload payload = new StreamPayload(metadataBlob.getInputStreamSupplier(), metadataBlob.getSize(), contentType);){
                ((YumContentFacet)this.getRepository().facet(YumContentFacet.class)).put(metadataBlob.getPath(), (Payload)payload, metadataBlob.getAssetKind());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to save new metadata", (Throwable)e);
        }
    }

    private void markDirectoryModified(List<MetadataBlob> metadataBlobs) {
        HashSet<String> processed = new HashSet<String>();
        YumHostedFacet hosted = (YumHostedFacet)this.getRepository().facet(YumHostedFacet.class);
        int depth = hosted.getRepodataDepth();
        for (MetadataBlob metadataBlob : metadataBlobs) {
            String folder = YumPathUtils.extractDirectoryAtDepth(org.apache.commons.lang3.StringUtils.removeStart((String)metadataBlob.getPath(), (String)"/"), depth).orElse("");
            if (processed.contains(folder)) continue;
            processed.add(folder);
            this.log.debug("Checking whether RPMs removed from {} during metadata generation", (Object)folder);
            hosted.setRpmsRemovedFlagIfCountChanged(StringUtils.isNotEmpty((String)folder) ? String.valueOf(folder) + "/" : folder, metadataBlob.getExpectedRpmCount());
        }
    }

    private void buildMetadata(YumMetadataInvalidationEvent event, Consumer<List<MetadataBlob>> updateListener) {
        if (this.cachingEnabled && event.isUseCache()) {
            this.createRepo.buildMetadataUsingCaching(this.getRepository(), updateListener, event.getMovedComponentIds());
        } else {
            this.createRepo.buildMetadataWithoutCaching(this.getRepository(), updateListener);
        }
    }

    private void maybeWait(YumMetadataInvalidationEvent event) {
        if (event.isWaitBeforeRebuild()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("Yum invalidation thread interrupted, proceeding with invalidation");
            }
        }
    }

    private boolean matchesRepository(AssetEvent event) {
        return event.getRepository().map(Repository::getName).map(name -> name.equals(this.getRepository().getName())).orElse(false);
    }

    private boolean isEventRelevant(AssetEvent event) {
        return event.getAsset().kind().equals(AssetKind.RPM.name()) || event.getAsset().kind().equals(AssetKind.COMPS.name());
    }
}

