/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;

@Named
@Singleton
public class YumQueryComponent {
    private static final String REPOMD_ASSET_PATH = "/repodata/repomd.xml";
    private static final String PATH_FILTER = "pathFilter";

    public long countRpmsInDirectory(Repository repository, @Nullable String folder) {
        folder = this.toFolder(folder);
        return this.queryByAssetKindAndStartWithByPath(repository, AssetKind.RPM, folder).count();
    }

    public long countCompsInDirectory(Repository repository, @Nullable String folder) {
        folder = this.toFolder(folder);
        return this.queryByAssetKindAndStartWithByPath(repository, AssetKind.COMPS, folder).count();
    }

    public Collection<String> getMetadataPathsThatHaveHadRpmsRemoved(Repository repository) {
        return Continuations.streamOf(((YumContentFacet)repository.facet(YumContentFacet.class)).get(AssetKind.REPOMD)).filter(asset -> {
            Map formatAttributes = FormatAttributesUtils.getFormatAttributes((FluentAsset)asset);
            return formatAttributes.getOrDefault("rpms_removed", false);
        }).map(Asset::path).collect(Collectors.toList());
    }

    public Iterable<FluentAsset> findRepodataAssetsOnPath(Repository repository, String path) {
        Objects.requireNonNull(repository, "Repository is required");
        Objects.requireNonNull(path, "Path is required");
        return Continuations.iterableOf((arg_0, arg_1) -> this.queryByAssetKindAndStartWithByPath(repository, AssetKind.REPODATA, path).browse(arg_0, arg_1));
    }

    public Iterable<FluentAsset> browseRpmsForPath(Repository repository, @Nullable String path) {
        return Continuations.iterableOf((arg_0, arg_1) -> this.queryByAssetKindAndStartWithByPath(repository, AssetKind.RPM, path).browse(arg_0, arg_1));
    }

    public Iterable<FluentAsset> browseCompsForPath(Repository repository, @Nullable String path) {
        return Continuations.iterableOf((arg_0, arg_1) -> this.queryByAssetKindAndStartWithByPath(repository, AssetKind.COMPS, path).browse(arg_0, arg_1));
    }

    public Iterable<FluentAsset> findCompsByAssetPath(Repository repository, String assetPath) {
        String filterString = "path = #{filterParams.assetPathParam} or path = #{filterParams.orAssetPathParam}";
        ImmutableMap filterParams = ImmutableMap.of((Object)"assetPathParam", (Object)assetPath, (Object)"orAssetPathParam", (Object)(String.valueOf(assetPath) + ".gz"));
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)((YumContentFacet)repository.facet(YumContentFacet.class)).assets().byFilter(filterString, (Map)filterParams)).browse(arg_0, arg_1));
    }

    public Optional<FluentAsset> findRepomd(Repository repository, @Nullable String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return ((YumContentFacet)repository.facet(YumContentFacet.class)).get(REPOMD_ASSET_PATH);
        }
        return ((YumContentFacet)repository.facet(YumContentFacet.class)).get(String.valueOf(path) + REPOMD_ASSET_PATH);
    }

    public Iterable<FluentAsset> browseRpmBlobsUpdatedSince(Repository repository, @Nullable String pathPrefix, long since) {
        return this.browseBlobsUpdatedSince(repository, pathPrefix, since, AssetKind.RPM);
    }

    public Iterable<FluentAsset> browseCompsBlobsUpdatedSince(Repository repository, @Nullable String pathPrefix, long since) {
        return this.browseBlobsUpdatedSince(repository, pathPrefix, since, AssetKind.COMPS);
    }

    private Iterable<FluentAsset> browseBlobsUpdatedSince(Repository repository, @Nullable String pathPrefix, long since, AssetKind kind) {
        HashMap<String, Object> filterParams = new HashMap<String, Object>();
        String filterString = " kind = #{filterParams.kindFilter}";
        filterParams.put("kindFilter", kind.name());
        filterString = kind == AssetKind.RPM ? String.valueOf(filterString) + " and component_id is not null" : String.valueOf(filterString) + " and component_id is null";
        if (StringUtils.isNotBlank((CharSequence)pathPrefix)) {
            filterString = String.valueOf(filterString) + " and path like #{filterParams.pathFilter}";
            filterParams.put(PATH_FILTER, String.valueOf(pathPrefix) + "%");
        }
        filterString = String.valueOf(filterString) + " and (SELECT cast((EXTRACT(EPOCH FROM BLOB_CREATED) * 1000) as bigint) FROM YUM_ASSET_BLOB WHERE ASSET_BLOB_ID = asset.ASSET_BLOB_ID) > #{filterParams.sinceFilter}";
        filterParams.put("sinceFilter", since);
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)((YumContentFacet)repository.facet(YumContentFacet.class)).assets().byFilter(filterString, filterParams)).browse(arg_0, arg_1));
    }

    public Iterable<FluentAsset> findAssetsByComponentIds(Repository repository, @Nullable String pathPrefix, List<Integer> componentIds) {
        if (componentIds.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder filter = new StringBuilder("component_id IN (");
        HashMap<String, Object> filterParams = new HashMap<String, Object>();
        int i = 0;
        while (i < componentIds.size()) {
            String param = "c" + i;
            filter.append("#{").append("filterParams").append(".").append(param).append("}");
            if (componentIds.size() > 1 && i < componentIds.size() - 1) {
                filter.append(", ");
            }
            filterParams.put(param, componentIds.get(i));
            ++i;
        }
        filter.append(")");
        if (StringUtils.isNotBlank((CharSequence)pathPrefix)) {
            filter.append(" and path like #{").append("filterParams").append(".pathFilter}");
            filterParams.put(PATH_FILTER, String.valueOf(pathPrefix) + "%");
        }
        String filterString = filter.toString();
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)((YumContentFacet)repository.facet(YumContentFacet.class)).assets().byFilter(filterString, filterParams)).browse(arg_0, arg_1));
    }

    private FluentQuery<FluentAsset> queryByAssetKindAndStartWithByPath(Repository repository, AssetKind assetKind, @Nullable String path) {
        HashMap<String, String> filterParams = new HashMap<String, String>();
        String filterString = " kind = #{filterParams.kindFilter}";
        filterParams.put("kindFilter", assetKind.name());
        if (StringUtils.isNotBlank((CharSequence)path)) {
            filterString = String.valueOf(filterString) + " and path LIKE #{filterParams.pathFilter}";
            filterParams.put(PATH_FILTER, String.valueOf(path) + "%");
        }
        filterString = assetKind == AssetKind.RPM ? String.valueOf(filterString) + " and component_id is not null" : String.valueOf(filterString) + " and component_id is null";
        return ((YumContentFacet)repository.facet(YumContentFacet.class)).assets().byFilter(filterString, filterParams);
    }

    private String toFolder(String folder) {
        if (StringUtils.isBlank((CharSequence)folder)) {
            return folder;
        }
        folder = folder.endsWith("/") ? folder : String.valueOf(folder) + "/";
        return StringUtils.prependIfMissing((String)folder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

