/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.datastore.YumContentFacet;
import org.sonatype.nexus.repository.yum.internal.gpg.YumSigningFacet;
import org.sonatype.nexus.repository.yum.internal.metadata.CompressedTempBlob;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdProcessor;
import org.sonatype.nexus.repository.yum.internal.metadata.YumAbsoluteUrlRemover;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.TempBlobConverter;
import org.sonatype.nexus.repository.yum.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.w3c.dom.Document;

@Named
@Facet.Exposed
public class YumProxyFacet
extends ContentProxyFacetSupport {
    private static final String REPODATA_PATH = "repodata/";
    public static final String RHUI_SIGNATURE_HEADER = "X-RHUI-SIGNATURE";
    public static final String RHUI_ID_HEADER = "X-RHUI-ID";
    private final RepomdProcessor repomdProcessor;
    private final TempBlobConverter tempBlobConverter;
    private final YumAbsoluteUrlRemover yumAbsoluteUrlRemover;

    @Inject
    public YumProxyFacet(RepomdProcessor repomdProcessor, TempBlobConverter tempBlobConverter, YumAbsoluteUrlRemover yumAbsoluteUrlRemover) {
        this.repomdProcessor = (RepomdProcessor)((Object)Preconditions.checkNotNull((Object)((Object)repomdProcessor)));
        this.tempBlobConverter = (TempBlobConverter)Preconditions.checkNotNull((Object)tempBlobConverter);
        this.yumAbsoluteUrlRemover = (YumAbsoluteUrlRemover)((Object)Preconditions.checkNotNull((Object)((Object)yumAbsoluteUrlRemover)));
    }

    protected Content doGet(Context context, Content staleContent) throws IOException {
        YumSigningFacet yumSigningFacet = (YumSigningFacet)this.facet(YumSigningFacet.class);
        Optional<Content> metadataSignature = yumSigningFacet.maybeSignRepoMetadata(context, this.getRepository());
        if (metadataSignature.isPresent()) {
            return metadataSignature.get();
        }
        return super.doGet(context, staleContent);
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        String assetPath = YumPathUtils.buildAssetPath(YumPathUtils.matcherState(context));
        String contentAssetPath = StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return ((YumContentFacet)this.facet(YumContentFacet.class)).get(contentAssetPath).map(FluentAsset::download).orElse(null);
    }

    protected Content store(Context context, Content content) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = YumPathUtils.buildAssetPath(matcherState);
        String contentAssetPath = StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        if (assetKind == AssetKind.RPM) {
            return ((YumContentFacet)this.facet(YumContentFacet.class)).put(contentAssetPath, (Payload)content, assetKind).download();
        }
        return this.putMetadata(contentAssetPath, content, assetKind, context).markAsCached((Payload)content).download();
    }

    protected String getUrl(@NotNull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    protected CacheController getCacheController(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        Headers headers = context.getRequest().getHeaders();
        this.copyHeaderIfPresent(request, headers, RHUI_SIGNATURE_HEADER);
        this.copyHeaderIfPresent(request, headers, RHUI_ID_HEADER);
        return super.execute(context, client, request);
    }

    private void clearRepodataIfRepomdAssetKind(AssetKind assetKind, String assetPath) {
        if (assetKind == AssetKind.REPOMD) {
            Continuations.streamOf(((YumContentFacet)this.facet(YumContentFacet.class)).get(AssetKind.REPODATA)).filter(e -> this.isAssetInSameFolderAsRepomd(assetPath, e.path())).forEach(FluentAsset::delete);
        }
    }

    private boolean isAssetInSameFolderAsRepomd(String assetPath, String assetName) {
        String prefix = assetPath.substring(0, assetPath.indexOf(REPODATA_PATH) + REPODATA_PATH.length());
        return assetName.startsWith(prefix);
    }

    private void copyHeaderIfPresent(HttpRequestBase request, Headers headers, String headerName) {
        if (headers.contains(headerName)) {
            this.log.debug("Adding header {} from Yum client", (Object)headerName);
            request.addHeader(headerName, headers.get(headerName));
        }
    }

    /*
     * Exception decompiling
     */
    protected FluentAsset processPrimary(String assetPath, Payload payload, AssetKind assetKind) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FluentAsset putMetadata(String assetPath, Content content, AssetKind assetKind, Context context) {
        this.clearRepodataIfRepomdAssetKind(assetKind, assetPath);
        if (AssetKind.REPOMD == assetKind) {
            return this.processRepomd(assetPath, (Payload)content, assetKind, context);
        }
        if (YumFacetUtils.isPrimary(assetPath, assetKind)) {
            return this.processPrimary(assetPath, (Payload)content, assetKind);
        }
        return ((YumContentFacet)this.facet(YumContentFacet.class)).put(assetPath, (Payload)content, assetKind);
    }

    /*
     * Loose catch block
     */
    private FluentAsset processRepomd(String assetPath, Payload payload, AssetKind assetKind, Context context) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (TempBlob tempBlob = ((YumContentFacet)this.facet(YumContentFacet.class)).ingest(payload, YumMetadataUtils.HASH_ALGORITHMS);){
                FluentAsset fluentAsset;
                TempBlob newMetadataContent;
                Throwable throwable2;
                block21: {
                    Document repomdXml = this.tempBlobConverter.toDocument(tempBlob);
                    this.repomdProcessor.process(repomdXml, path -> this.fetchMetadata(path, this.getRepository(), context));
                    String contentType = payload.getContentType();
                    throwable2 = null;
                    Object var11_15 = null;
                    newMetadataContent = this.tempBlobConverter.toTempBlob(repomdXml, this.getRepository());
                    BlobPayload newMetadataPayload = new BlobPayload(newMetadataContent.getBlob(), contentType);
                    fluentAsset = ((YumContentFacet)this.facet(YumContentFacet.class)).put(assetPath, (Payload)newMetadataPayload, assetKind);
                    if (newMetadataContent == null) break block21;
                    newMetadataContent.close();
                }
                return fluentAsset;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (newMetadataContent != null) {
                                newMetadataContent.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private Content fetchMetadata(String path, Repository repository, Context context) {
        Request mappingRequest = new Request.Builder().action("GET").path("/" + path).build();
        try {
            Response response = ((ViewFacet)repository.facet(ViewFacet.class)).dispatch(mappingRequest, context);
            int status = response.getStatus().getCode();
            if (status != 200) {
                this.log.warn("Failed to fetch metadata file for path {} and repository {}. Received status code {}", new Object[]{path, repository.getName(), status});
            }
            return (Content)response.getPayload();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ Map lambda$3(CompressedTempBlob compressedTempBlob) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("modified", true);
        attributes.put("open-sha1", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.SHA1).toString());
        attributes.put("open-sha256", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.SHA256).toString());
        attributes.put("open-sha512", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.SHA512).toString());
        attributes.put("open-md5", compressedTempBlob.getDecompressedHashes().get(HashAlgorithm.MD5).toString());
        attributes.put("open-size", compressedTempBlob.getDecompressedSize());
        return attributes;
    }
}

