/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.utils.PreReleaseEvaluator;
import org.sonatype.nexus.repository.yum.AssetKind;

@Named(value="yum")
@Singleton
public class YumPreReleaseEvaluator
implements PreReleaseEvaluator {
    private static final List<String> preReleaseMap = ImmutableList.of((Object)"alpha", (Object)"beta", (Object)"rc", (Object)"pre", (Object)"prerelease", (Object)"snapshot");

    public boolean isPreRelease(Component component, Iterable<Asset> assets) {
        return StreamSupport.stream(assets.spliterator(), false).filter(YumPreReleaseEvaluator::isRpm).map(asset -> asset.attributes().child("yum")).map(attributes -> (String)attributes.get("release", String.class)).filter(Objects::nonNull).allMatch(YumPreReleaseEvaluator::containsPrereleaseSignature);
    }

    private static boolean containsPrereleaseSignature(String str) {
        String lowerStr = Strings2.lower((String)str);
        return preReleaseMap.stream().anyMatch(lowerStr::contains);
    }

    private static boolean isRpm(Asset asset) {
        return AssetKind.RPM.name().equals(asset.kind());
    }
}

