/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore.internal;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.director.ContentDirector;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.yum.datastore.internal.YumHostedFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoFacet;

@Named(value="yum")
@Singleton
public class YumContentDirector
implements ContentDirector {
    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public boolean allowMoveTo(FluentComponent component, Repository destination) {
        int destinationDepth;
        YumHostedFacet hostedFacet = (YumHostedFacet)component.repository().facet(YumHostedFacet.class);
        int componentDepth = hostedFacet.getComponentDepth(component);
        return componentDepth >= (destinationDepth = ((YumHostedFacet)destination.facet(YumHostedFacet.class)).getRepodataDepth().intValue());
    }

    public void afterMove(List<Map<String, String>> components, Repository destination) {
        CreateRepoFacet createRepoFacet = (CreateRepoFacet)destination.facet(CreateRepoFacet.class);
        List<String> componentIds = this.getComponentIds(components);
        createRepoFacet.invalidateMetadataWithoutWaiting(true, componentIds);
    }

    private List<String> getComponentIds(List<Map<String, String>> components) {
        return components.stream().map(c -> (String)c.get("id")).collect(Collectors.toList());
    }
}

