/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.datastore;

import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.YumAssetAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.YumComponentAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.createrepo.RpmRedeployedEvent;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;

@Named(value="yum")
@Facet.Exposed
public class YumContentFacet
extends ContentFacetSupport {
    private final YumRpmParser rpmParser;
    private final YumComponentAttributePopulator componentAttributePopulator;
    private final YumAssetAttributePopulator assetAttributePopulator;

    @Inject
    public YumContentFacet(@Named(value="yum") FormatStoreManager formatStoreManager, YumRpmParser rpmParser, YumComponentAttributePopulator componentAttributePopulator, YumAssetAttributePopulator assetAttributePopulator) {
        super(formatStoreManager);
        this.rpmParser = rpmParser;
        this.componentAttributePopulator = componentAttributePopulator;
        this.assetAttributePopulator = assetAttributePopulator;
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy writePolicy = super.writePolicy(asset);
        if (WritePolicy.ALLOW_ONCE == writePolicy) {
            String kind = asset.kind();
            if (!Objects.equals(AssetKind.RPM.name(), kind)) {
                return WritePolicy.ALLOW;
            }
        }
        return writePolicy;
    }

    public Optional<FluentAsset> get(String assetPath) {
        return this.assets().path(assetPath).find();
    }

    public Iterable<FluentAsset> get(AssetKind assetKind) {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.assets().byKind(assetKind.name())).browse(arg_0, arg_1));
    }

    public Iterable<FluentAsset> get() {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentAssets)this.assets()).browse(arg_0, arg_1));
    }

    public FluentAsset putHardLink(String assetPath, Blob blob, Map<HashAlgorithm, HashCode> checksums, AssetKind assetKind) {
        if (assetKind == AssetKind.RPM) {
            return this.putRPMHardLink(assetPath, blob, checksums);
        }
        return this.putMetadataHardLink(assetPath, blob, checksums, assetKind);
    }

    private FluentAsset putRPMHardLink(String assetPath, Blob blob, Map<HashAlgorithm, HashCode> checksums) {
        YumRpm yumRpm = this.parse(blob, assetPath);
        boolean isRpmRedeploy = this.get(assetPath).isPresent();
        FluentComponent fluentComponent = this.getOrCreateRpmComponent(yumRpm);
        FluentAssetBuilder fluentAssetBuilder = this.prepareRpmAsset(assetPath, yumRpm, fluentComponent);
        FluentAsset fluentAsset = fluentAssetBuilder.blob(blob, checksums).save();
        if (isRpmRedeploy) {
            this.getEventManager().post((Object)new RpmRedeployedEvent(this.getRepository().getName()));
        }
        return fluentAsset;
    }

    private FluentAsset putMetadataHardLink(String assetPath, Blob blob, Map<HashAlgorithm, HashCode> checksums, AssetKind assetKind) {
        FluentAssetBuilder fluentAssetBuilder = this.prepareMetadataAsset(assetPath, assetKind);
        return fluentAssetBuilder.blob(blob, checksums).save();
    }

    public FluentAsset put(String assetPath, Payload payload, AssetKind assetKind) {
        if (assetKind == AssetKind.RPM) {
            return this.putRPM(assetPath, payload);
        }
        return this.putMetadata(assetPath, payload, assetKind);
    }

    private FluentAsset putRPM(String assetPath, Payload payload) {
        boolean isRpmRedeploy = this.get(assetPath).isPresent();
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, YumMetadataUtils.HASH_ALGORITHMS);){
            YumRpm yumRpm = this.parse(tempBlob.getBlob(), assetPath);
            FluentComponent fluentComponent = this.getOrCreateRpmComponent(yumRpm);
            FluentAssetBuilder fluentAssetBuilder = this.prepareRpmAsset(assetPath, yumRpm, fluentComponent);
            FluentAsset fluentAsset = fluentAssetBuilder.blob(tempBlob).save();
            FluentAsset result = fluentAsset.markAsCached(payload);
            if (isRpmRedeploy) {
                this.getEventManager().post((Object)new RpmRedeployedEvent(this.getRepository().getName()));
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentAsset putMetadata(String assetPath, Payload payload, AssetKind assetKind) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, YumMetadataUtils.HASH_ALGORITHMS);){
            FluentAssetBuilder fluentAssetBuilder = this.prepareMetadataAsset(assetPath, assetKind);
            FluentAsset asset = fluentAssetBuilder.blob(tempBlob).save();
            return asset.markAsCached(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FluentComponent getOrCreateRpmComponent(YumRpm yumRpm) {
        Map<String, Object> componentFormatAttributes = this.componentAttributePopulator.extractComponentAttributes(yumRpm);
        String componentName = yumRpm.getName();
        String componentVersion = yumRpm.getFullVersion();
        return this.components().name(componentName).version(componentVersion).attributes("yum", componentFormatAttributes).getOrCreate();
    }

    private FluentAssetBuilder prepareRpmAsset(String assetPath, YumRpm yumRpm, FluentComponent component) {
        Map<String, Object> assetFormatAttributes = this.assetAttributePopulator.extractAssetAttributes(yumRpm);
        assetFormatAttributes.put("asset_kind", AssetKind.RPM.name());
        return this.assets().path(assetPath).kind(AssetKind.RPM.name()).component((Component)component).attributes("yum", assetFormatAttributes);
    }

    private FluentAssetBuilder prepareMetadataAsset(String assetPath, AssetKind assetKind) {
        return this.assets().path(assetPath).kind(assetKind.name()).attributes("yum", Collections.singletonMap("asset_kind", assetKind.name()));
    }

    private YumRpm parse(Blob blob, String assetPath) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = blob.getInputStream();){
                return this.rpmParser.parse(inputStream, assetPath);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TempBlob ingest(Payload payload, Iterable<HashAlgorithm> hashing) {
        return this.blobs().ingest(payload, hashing);
    }

    public TempBlob ingest(InputStream is, @Nullable String contentType, Iterable<HashAlgorithm> hashing) {
        return this.blobs().ingest(is, contentType, hashing);
    }
}

