/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.yum.api.YumAttributes;
import org.sonatype.nexus.repository.yum.api.YumHostedApiRepository;

@Named(value="yum")
public class YumApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    @Inject
    public YumApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        if (repository.getType() instanceof HostedType) {
            boolean online = repository.getConfiguration().isOnline();
            String name = repository.getName();
            String url = repository.getUrl();
            return new YumHostedApiRepository(name, url, online, this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.createYumAttributes(repository), this.getComponentAttributes(repository));
        }
        return super.adapt(repository);
    }

    private YumAttributes createYumAttributes(Repository repository) {
        NestedAttributesMap yumAttributes = repository.getConfiguration().attributes("yum");
        Integer repodataDepth = YumApiRepositoryAdapter.toInt((Number)((Number)yumAttributes.get("repodataDepth", Number.class)));
        String deployPolicy = (String)yumAttributes.get("deployPolicy", String.class);
        return new YumAttributes(repodataDepth, deployPolicy);
    }
}

