/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.sonatype.nexus.vulnerability.internal.AggregatedDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DayDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DownloadCountStore;
import com.sonatype.nexus.vulnerability.internal.orient.OrientDownloadCountEntityAdapter;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Singleton
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class OrientDownloadCountStore
extends StateGuardLifecycleSupport
implements DownloadCountStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientDownloadCountEntityAdapter entityAdapter;

    @Inject
    public OrientDownloadCountStore(@Named(value="component") Provider<DatabaseInstance> databaseInstance, OrientDownloadCountEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientDownloadCountEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void add(String repositoryName, String namespace, String name, String version, LocalDate date, String ipAddress, String username, int downloadCount) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.incrementCount(db, repositoryName, namespace, name, version, date, ipAddress, username, downloadCount));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<AggregatedDownloadCount> getDownloadCountByIp(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.aggregateByIpAddress(db, namespace, name, version, start, end).collect(Collectors.toList()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<AggregatedDownloadCount> getDownloadCountByRepositoryName(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.aggregateByRepositoryName(db, namespace, name, version, start, end).collect(Collectors.toList()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<AggregatedDownloadCount> getDownloadCountByUsername(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.aggregateByUsername(db, namespace, name, version, start, end).collect(Collectors.toList()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<DayDownloadCount> getDownloadsByDay(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.aggregateByDay(db, namespace, name, version, start, end, true).collect(Collectors.toList()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<DayDownloadCount> getNonVulnerableDownloadsByDay(String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.aggregateByDay(db, namespace, name, version, start, end, false).collect(Collectors.toList()));
    }

    @Override
    public void purge() {
        OrientTransactional.inTx(this.databaseInstance).run(this.entityAdapter::purge);
    }
}

