/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.sonatype.nexus.vulnerability.internal.AggregatedDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DayDownloadCount;
import com.sonatype.nexus.vulnerability.internal.orient.OrientCoordinateDownload;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class OrientDownloadCountEntityAdapter
extends IterableEntityAdapter<OrientCoordinateDownload> {
    private static final String DB_CLASS = new OClassNameBuilder().type("coordinate_download_count").build();
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String P_DATE = "date";
    private static final String P_NAMESPACE = "namespace";
    private static final String P_NAME = "name";
    private static final String P_VERSION = "version";
    private static final String P_DOWNLOAD_COUNT = "download_count";
    private static final String P_IP_ADDRESS = "ip_address";
    private static final String P_USERNAME = "username";
    private static final String I_PRIMARY = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").property("namespace").property("name").property("version").property("date").property("ip_address").property("username").build();
    private static final String I_IP_AGGREGATE = new OIndexNameBuilder().type(DB_CLASS).property("namespace").property("name").property("version").property("ip_address").build();
    private static final String I_REPOSITORY_AGGREGATE = new OIndexNameBuilder().type(DB_CLASS).property("namespace").property("name").property("version").property("repository_name").build();
    private static final String I_USERNAME_AGGREGATE = new OIndexNameBuilder().type(DB_CLASS).property("namespace").property("name").property("version").property("username").build();
    private static final String SELECT_DOWNLOADS_BY_DATE = OrientDownloadCountEntityAdapter.createQueryAggregateDownloadsBy("date", true);
    private static final String SELECT_NON_VULNERABLE_DOWNLOADS_BY_DATE = OrientDownloadCountEntityAdapter.createQueryAggregateDownloadsBy("date", false);
    private static final String SELECT_DOWNLOADS_BY_IP = OrientDownloadCountEntityAdapter.createQueryAggregateDownloadsBy("ip_address", true);
    private static final String SELECT_DOWNLOADS_BY_USERNAME = OrientDownloadCountEntityAdapter.createQueryAggregateDownloadsBy("username", true);
    private static final String SELECT_DOWNLOADS_BY_REPOSITORY = OrientDownloadCountEntityAdapter.createQueryAggregateDownloadsBy("repository_name", true);

    @Inject
    public OrientDownloadCountEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REPOSITORY_NAME, OType.STRING);
        type.createProperty(P_NAMESPACE, OType.STRING);
        type.createProperty(P_NAME, OType.STRING);
        type.createProperty(P_VERSION, OType.STRING);
        type.createProperty(P_DATE, OType.DATE);
        type.createProperty(P_DOWNLOAD_COUNT, OType.INTEGER);
        type.createProperty(P_IP_ADDRESS, OType.STRING);
        type.createProperty(P_USERNAME, OType.STRING);
        type.createIndex(I_PRIMARY, OClass.INDEX_TYPE.UNIQUE, new String[]{P_REPOSITORY_NAME, P_NAMESPACE, P_NAME, P_VERSION, P_DATE, P_IP_ADDRESS, P_USERNAME});
        type.createIndex(I_IP_AGGREGATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_NAMESPACE, P_NAME, P_VERSION, P_IP_ADDRESS});
        type.createIndex(I_REPOSITORY_AGGREGATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_NAMESPACE, P_NAME, P_VERSION, P_REPOSITORY_NAME});
        type.createIndex(I_USERNAME_AGGREGATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_NAMESPACE, P_NAME, P_VERSION, P_USERNAME});
    }

    protected OrientCoordinateDownload newEntity() {
        return new OrientCoordinateDownload();
    }

    protected void readFields(ODocument document, OrientCoordinateDownload entity) {
        entity.withRepositoryName((String)document.field(P_REPOSITORY_NAME));
        entity.withNamespace((String)document.field(P_NAMESPACE));
        entity.withName((String)document.field(P_NAME));
        entity.withVersion((String)document.field(P_VERSION));
        entity.withDownloadCount((Integer)document.field(P_DOWNLOAD_COUNT));
        entity.withDate(DateHelper.toLocalDate((Date)((Date)document.field(P_DATE, Date.class))));
        entity.withIpAddress((String)document.field(P_IP_ADDRESS));
        entity.withUsername((String)document.field(P_USERNAME));
    }

    protected void writeFields(ODocument document, OrientCoordinateDownload entity) {
        document.field(P_REPOSITORY_NAME, (Object)entity.getRepositoryName());
        document.field(P_NAMESPACE, (Object)entity.getNamespace());
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_VERSION, (Object)entity.getVersion());
        document.field(P_DOWNLOAD_COUNT, (Object)entity.getDownloadCount());
        document.field(P_DATE, (Object)DateHelper.atStartOfDay((LocalDate)entity.getDate()), new OType[]{OType.DATE});
        document.field(P_IP_ADDRESS, (Object)entity.getIpAddress());
        document.field(P_USERNAME, (Object)entity.getUsername());
    }

    public Stream<DayDownloadCount> aggregateByDay(ODatabaseDocumentTx db, String namespace, String name, Collection<String> version, LocalDate start, LocalDate end, boolean vulnerable) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)namespace);
        Preconditions.checkNotNull((Object)name);
        String query = vulnerable ? SELECT_DOWNLOADS_BY_DATE : SELECT_NON_VULNERABLE_DOWNLOADS_BY_DATE;
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{OrientDownloadCountEntityAdapter.buildQueryParameters(namespace, name, version, start, end)});
        return StreamSupport.stream(docs.spliterator(), false).map(OrientDownloadCountEntityAdapter::toDayDownloadCount);
    }

    public Stream<AggregatedDownloadCount> aggregateByIpAddress(ODatabaseDocumentTx db, String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)name);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(SELECT_DOWNLOADS_BY_IP)).execute(new Object[]{OrientDownloadCountEntityAdapter.buildQueryParameters(namespace, name, version, start, end)});
        return StreamSupport.stream(docs.spliterator(), false).map(doc -> OrientDownloadCountEntityAdapter.toAggregatedDownloadCount(P_IP_ADDRESS, doc));
    }

    public Stream<AggregatedDownloadCount> aggregateByRepositoryName(ODatabaseDocumentTx db, String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)name);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(SELECT_DOWNLOADS_BY_REPOSITORY)).execute(new Object[]{OrientDownloadCountEntityAdapter.buildQueryParameters(namespace, name, version, start, end)});
        return StreamSupport.stream(docs.spliterator(), false).map(doc -> OrientDownloadCountEntityAdapter.toAggregatedDownloadCount(P_REPOSITORY_NAME, doc));
    }

    public Stream<AggregatedDownloadCount> aggregateByUsername(ODatabaseDocumentTx db, String namespace, String name, Collection<String> version, LocalDate start, LocalDate end) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)name);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(SELECT_DOWNLOADS_BY_USERNAME)).execute(new Object[]{OrientDownloadCountEntityAdapter.buildQueryParameters(namespace, name, version, start, end)});
        return StreamSupport.stream(docs.spliterator(), false).map(doc -> OrientDownloadCountEntityAdapter.toAggregatedDownloadCount(P_USERNAME, doc));
    }

    public void incrementCount(ODatabaseDocumentTx db, String repositoryName, String namespace, String name, String version, LocalDate date, String ipAddress, String username, int downloadCount) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)namespace);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkNotNull((Object)date);
        Preconditions.checkNotNull((Object)ipAddress);
        Preconditions.checkNotNull((Object)username);
        Map<String, Object> parameters = OrientDownloadCountEntityAdapter.buildQueryParameters(repositoryName, namespace, name, version, date, ipAddress, username);
        parameters.put("downloadCount", downloadCount);
        String query = String.format("UPDATE %s INCREMENT %s = :downloadCount WHERE %s = :repositoryName AND %s = :namespace AND %s = :name AND %s = :version AND %s = :date AND %s = :ipAddress AND %s = :username", DB_CLASS, P_DOWNLOAD_COUNT, P_REPOSITORY_NAME, P_NAMESPACE, P_NAME, P_VERSION, P_DATE, P_IP_ADDRESS, P_USERNAME);
        Integer updateCount = (Integer)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        if (updateCount < 1) {
            this.addEntity(db, (Entity)this.newEntity().withDate(date).withRepositoryName(repositoryName).withNamespace(namespace).withName(name).withVersion(version).withUsername(username).withIpAddress(ipAddress).withDownloadCount(downloadCount));
        }
    }

    public void purge(ODatabaseDocumentTx db) {
        db.command((OCommandRequest)new OCommandSQL("TRUNCATE CLASS " + DB_CLASS)).execute(new Object[0]);
    }

    @VisibleForTesting
    Integer getCount(ODatabaseDocumentTx db, String repositoryName, String namespace, String name, String version, LocalDate date, String ipAddress, String username) {
        String query = String.format("SELECT %s FROM %s WHERE %s = :repositoryName AND %s = :namespace AND %s = :name AND %s = :version AND %s = :date AND %s = :ipAddress AND %s = :username", P_DOWNLOAD_COUNT, DB_CLASS, P_REPOSITORY_NAME, P_NAMESPACE, P_NAME, P_VERSION, P_DATE, P_IP_ADDRESS, P_USERNAME);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{OrientDownloadCountEntityAdapter.buildQueryParameters(repositoryName, namespace, name, version, date, ipAddress, username)});
        return Optional.ofNullable((ODocument)Iterables.getFirst((Iterable)docs, null)).map(doc -> (Integer)doc.field(P_DOWNLOAD_COUNT, Integer.class)).orElse(null);
    }

    private static Map<String, Object> buildQueryParameters(String namespace, String name, Collection<String> version, LocalDate startDate, LocalDate endDate) {
        Map<String, Object> params = OrientDownloadCountEntityAdapter.buildQueryParameters(null, namespace, name, null, null, null, null);
        if (version != null) {
            params.put("versions", version);
        }
        if (endDate != null) {
            params.put("endDate", DateHelper.atStartOfDay((LocalDate)endDate));
        }
        if (startDate != null) {
            params.put("startDate", DateHelper.atStartOfDay((LocalDate)startDate));
        }
        return params;
    }

    private static Map<String, Object> buildQueryParameters(String repositoryName, String namespace, String name, String version, LocalDate date, String ipAddress, String username) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (repositoryName != null) {
            params.put("repositoryName", repositoryName);
        }
        if (namespace != null) {
            params.put(P_NAMESPACE, namespace);
        }
        if (name != null) {
            params.put(P_NAME, name);
        }
        if (version != null) {
            params.put(P_VERSION, version);
        }
        if (date != null) {
            params.put(P_DATE, DateHelper.atStartOfDay((LocalDate)date));
        }
        if (ipAddress != null) {
            params.put("ipAddress", ipAddress);
        }
        if (username != null) {
            params.put(P_USERNAME, username);
        }
        return params;
    }

    private static DayDownloadCount toDayDownloadCount(ODocument doc) {
        LocalDate date = DateHelper.toLocalDate((Date)((Date)doc.field(P_DATE, Date.class)));
        return new DayDownloadCount(date, (Long)doc.field("total_count", Long.class));
    }

    private static AggregatedDownloadCount toAggregatedDownloadCount(String aggregatorField, ODocument doc) {
        return new AggregatedDownloadCount((String)doc.field(aggregatorField), (Long)doc.field("total_count", Long.class));
    }

    private static String createQueryAggregateDownloadsBy(String fieldName, boolean vulnerable) {
        String operator = vulnerable ? "IN" : "NOT IN";
        return String.format("SELECT %s, sum(%s) AS total_count FROM %s WHERE %s = :namespace AND %s = :name AND %s " + operator + " :versions " + "AND %s >= :startDate AND %s <= :endDate " + "GROUP BY %s ORDER BY %s", fieldName, P_DOWNLOAD_COUNT, DB_CLASS, P_NAMESPACE, P_NAME, P_VERSION, P_DATE, P_DATE, fieldName, P_DATE);
    }
}

