/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.vulnerability.internal.AggregatedDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DayDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DownloadCountStore;
import com.sonatype.nexus.vulnerability.internal.log.RequestLogAggregation;
import com.sonatype.nexus.vulnerability.internal.log.RequestLogAggregator;
import com.sonatype.nexus.vulnerability.internal.log.VulnerabilityInfoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@FeatureFlag(name="nexus.vuln.main.featureFlag", enabledByDefault=true)
@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class VulnerabilityRadarService
extends StateGuardLifecycleSupport {
    private final VulnerabilityInfoService vulnerabilityInfoService;
    private final RequestLogAggregator requestLogAggregator;
    private final DownloadCountStore downloadCountStore;

    @Inject
    public VulnerabilityRadarService(VulnerabilityInfoService vulnerabilityInfoService, RequestLogAggregator requestLogAggregator, DownloadCountStore downloadCountStore) {
        this.vulnerabilityInfoService = (VulnerabilityInfoService)((Object)Preconditions.checkNotNull((Object)((Object)vulnerabilityInfoService)));
        this.requestLogAggregator = (RequestLogAggregator)((Object)Preconditions.checkNotNull((Object)((Object)requestLogAggregator)));
        this.downloadCountStore = (DownloadCountStore)Preconditions.checkNotNull((Object)downloadCountStore);
    }

    protected void doStart() {
    }

    protected void recalculateStatistics() {
        Map<String, List<String>> vulnerableComponentsAndVersions = this.vulnerabilityInfoService.getVulnerableComponentsAndVersions();
        ArrayList<String> vulnerableAssets = new ArrayList<String>(vulnerableComponentsAndVersions.keySet());
        this.downloadCountStore.purge();
        RequestLogAggregation requestLogAggregation = this.requestLogAggregator.versionRequestCount(vulnerableAssets).orElseGet(RequestLogAggregation::new);
        requestLogAggregation.getResults().forEach(this::increment);
    }

    @Guarded(by={"STARTED"})
    public void increment(RequestLogAggregation.DownloadKey key, int count) {
        this.downloadCountStore.add(key.getSourceRepo(), "", key.getAssetName(), key.getVersion(), key.getDownloadDate(), key.getIpAddress(), key.getUser(), count);
    }

    @Deprecated
    @Guarded(by={"STARTED"})
    public void increment(String assetName, LocalDate dateTime, String version, String user, String clientIp, String sourceRepo) {
        this.increment(new RequestLogAggregation.DownloadKey(assetName, version, user, clientIp, sourceRepo, dateTime), 1);
    }

    @Guarded(by={"STARTED"})
    public List<DayDownloadCount> getDownloadsPerDay(String assetName) {
        return this.downloadCountStore.getDownloadsByDay("", assetName, null, null, null);
    }

    @Guarded(by={"STARTED"})
    public List<AggregatedDownloadCount> getDownloadsByUser(String assetName) {
        return this.downloadCountStore.getDownloadCountByUsername("", assetName, null, null, null);
    }

    @Guarded(by={"STARTED"})
    public List<AggregatedDownloadCount> getDownloadsByIp(String assetName) {
        return this.downloadCountStore.getDownloadCountByIp("", assetName, null, null, null);
    }

    @Guarded(by={"STARTED"})
    public List<AggregatedDownloadCount> getDownloadsBySourceRepo(String assetName) {
        return this.downloadCountStore.getDownloadCountByRepositoryName("", assetName, null, null, null);
    }
}

