/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.vulnerability.internal.log.RequestLogAggregation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;

@Named
@Singleton
public class VulnerabilityDataSource
extends ComponentSupport {
    private static final String FILE_NAME = "vuln-info.json";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public VulnerabilityDataSource(ApplicationDirectories applicationDirectories) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    public Optional<RequestLogAggregation> loadPreviousAggregation() {
        File[] vulnFiles = this.applicationDirectories.getTemporaryDirectory().listFiles((file, name) -> name.equals(FILE_NAME));
        try {
            if (vulnFiles.length == 1) {
                ObjectReader aggregationReader = this.objectMapper.readerFor(RequestLogAggregation.class);
                return Optional.ofNullable((RequestLogAggregation)((Object)aggregationReader.readValue((InputStream)new BufferedInputStream(new FileInputStream(vulnFiles[0])))));
            }
            return Optional.empty();
        }
        catch (Exception exception) {
            this.log.info("Failed to load file, assuming no prev work");
            return Optional.empty();
        }
    }

    public void save(RequestLogAggregation requestLogAggregation) {
        try {
            File vulnInfoFile = new File(this.applicationDirectories.getTemporaryDirectory(), FILE_NAME);
            this.objectMapper.writeValue((OutputStream)new BufferedOutputStream(new FileOutputStream(vulnInfoFile)), (Object)requestLogAggregation);
        }
        catch (Exception exception) {
            this.log.info("Failed to save vuln file");
        }
    }
}

