/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import com.google.common.util.concurrent.RateLimiter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.function.IOSupplier;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;

@Named
@Singleton
public class RequestLogReader
extends ComponentSupport {
    private final Optional<RateLimiter> rateLimiter;
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public RequestLogReader(ApplicationDirectories applicationDirectories, @Named(value="${nexus.vuln.requestLogReader.ratePerSecond:-0}") double rateLimit) {
        this.applicationDirectories = Objects.requireNonNull(applicationDirectories);
        this.rateLimiter = rateLimit > 0.0 ? Optional.of(RateLimiter.create((double)rateLimit)) : Optional.empty();
    }

    public List<IOSupplier<BufferedReader>> getLogReaders() {
        String workDir = this.applicationDirectories.getWorkDirectory().getPath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> files = Files.list(Paths.get(String.valueOf(workDir) + "/log", new String[0]));){
                return files.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.toString().contains("request")).map(Path::toFile).map(this::buildReader).filter(Objects::nonNull).map(reader -> () -> reader).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("Failed to read the files in the work directory {}", (Object)workDir);
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    private BufferedReader buildReader(File logFile) {
        BufferedReader reader = null;
        try {
            FileInputStream fileStream = new FileInputStream(logFile);
            reader = logFile.getPath().endsWith("gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(fileStream), StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(fileStream));
            if (this.rateLimiter.isPresent()) {
                return new RateLimitedBufferedReader((Reader)reader, this.rateLimiter.get());
            }
        }
        catch (IOException e) {
            this.log.warn("Failed to build a reader for the logFile {}", (Object)logFile, (Object)e);
        }
        return reader;
    }

    private static class RateLimitedBufferedReader
    extends BufferedReader {
        private final RateLimiter rateLimiter;

        public RateLimitedBufferedReader(Reader in, RateLimiter rateLimiter) {
            super(in);
            this.rateLimiter = rateLimiter;
        }

        @Override
        public String readLine() throws IOException {
            this.rateLimiter.acquire();
            return super.readLine();
        }
    }
}

