/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.log;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.vulnerability.internal.log.LogInformation;
import com.sonatype.nexus.vulnerability.internal.log.RequestLogAggregation;
import com.sonatype.nexus.vulnerability.internal.log.RequestLogReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.function.IOSupplier;
import org.apache.tika.utils.ExceptionUtils;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class RequestLogAggregator
extends ComponentSupport {
    private static final String LOG_LINE_DEFAULT_REGEX = "^\\[?(?<ip>[a-zA-Z0-9.:]*)\\]? \\S+ (?<user>[^ ]+) \\[(?<dateTime>[^\\]]+)\\] \"(?<verb>[A-Za-z]+) (?<path>[^ ]+) (?<httpVersion>[^\"]+)\" (?<statusCode>[0-9]+) [^ ]+ (?<bytesSent>[0-9]+) (?<elapsedTime>[0-9]+) \"(?<userAgent>[^\"]+)\" \\[(?<thread>[^\\]]+)\\]";
    private static final String LOG4J_VERSION_REGEX = "\\\"GET .*\\/(repository|repositories|groups)\\/(?<repository>[^\\/]+)(\\/content)?\\/org\\/apache\\/logging\\/log4j\\/log4j-core\\/(?<version>[^\\/]+)\\/log4j-core-\\k<version>.jar HTTP/1.1\\\" 200";
    private static final String LOG_DATETIME_REGEX = "(?<dateTime>(\\d{2}\\/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\/\\d{4}:\\d{2}:\\d{2}:\\d{2}\\s\\+\\d{4}))";
    protected static final Pattern LOG_PATTERN = Pattern.compile("^\\[?(?<ip>[a-zA-Z0-9.:]*)\\]? \\S+ (?<user>[^ ]+) \\[(?<dateTime>[^\\]]+)\\] \"(?<verb>[A-Za-z]+) (?<path>[^ ]+) (?<httpVersion>[^\"]+)\" (?<statusCode>[0-9]+) [^ ]+ (?<bytesSent>[0-9]+) (?<elapsedTime>[0-9]+) \"(?<userAgent>[^\"]+)\" \\[(?<thread>[^\\]]+)\\]");
    protected static final Pattern LOG4J_PATTERN = Pattern.compile("\\\"GET .*\\/(repository|repositories|groups)\\/(?<repository>[^\\/]+)(\\/content)?\\/org\\/apache\\/logging\\/log4j\\/log4j-core\\/(?<version>[^\\/]+)\\/log4j-core-\\k<version>.jar HTTP/1.1\\\" 200");
    private static final Pattern LOG_DATETIME_PATTERN = Pattern.compile("(?<dateTime>(\\d{2}\\/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\/\\d{4}:\\d{2}:\\d{2}:\\d{2}\\s\\+\\d{4}))");
    protected final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MMM/yyyy:kk:mm:ss Z");
    private final RequestLogReader requestLogReader;

    @Inject
    public RequestLogAggregator(RequestLogReader requestLogReader) {
        this.requestLogReader = (RequestLogReader)((Object)Preconditions.checkNotNull((Object)((Object)requestLogReader)));
    }

    public Optional<RequestLogAggregation> versionRequestCount(List<String> assetNames) {
        List<IOSupplier<BufferedReader>> logReaders = this.requestLogReader.getLogReaders();
        return Optional.of(this.parseLogFiles(assetNames, logReaders));
    }

    private RequestLogAggregation parseLogFiles(List<String> assetNames, List<IOSupplier<BufferedReader>> logReaders) {
        RequestLogAggregation requestLogAggregation = new RequestLogAggregation();
        for (IOSupplier<BufferedReader> supplier : logReaders) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader reader = (BufferedReader)supplier.get();){
                    String line;
                    if (!Objects.nonNull(reader)) continue;
                    String first = reader.readLine();
                    String last = null;
                    block8: while ((line = reader.readLine()) != null) {
                        last = line;
                        for (String assetName : assetNames) {
                            if (!line.contains(assetName)) continue;
                            LogInformation logInformation = this.extractLogInformation(line, assetName);
                            if (!Objects.nonNull(logInformation)) continue block8;
                            requestLogAggregation.increment(logInformation);
                            continue block8;
                        }
                    }
                    requestLogAggregation.setStart(this.extractDate(first));
                    requestLogAggregation.setEnd(this.extractDate(last));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to load or process a log file for {} with exception message: {}", assetNames, (Object)e.getMessage());
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return requestLogAggregation;
    }

    @Nullable
    protected LocalDateTime extractDate(String logLine) {
        Matcher matcher = LOG_DATETIME_PATTERN.matcher(logLine);
        if (matcher.find()) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(matcher.group("dateTime"), this.formatter);
            return zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        }
        return null;
    }

    private LogInformation extractLogInformation(String logLine, String assetName) {
        Matcher defaultMatcher = LOG_PATTERN.matcher(logLine);
        if (!defaultMatcher.matches()) {
            this.log.debug("Log line has assetName {} but failed to match the default log line format {}", (Object)assetName, (Object)logLine);
            return null;
        }
        Matcher log4jMatcher = LOG4J_PATTERN.matcher(logLine);
        if (!log4jMatcher.find()) {
            this.log.debug("Log line has assetName {} but failed to match the log4j-core format {}", (Object)assetName, (Object)logLine);
            return null;
        }
        String ip = defaultMatcher.group("ip");
        if ("".equals(ip)) {
            ip = "(unknown)";
        }
        String user = defaultMatcher.group("user");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(defaultMatcher.group("dateTime"), this.formatter);
        OffsetDateTime dateTime = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime();
        String path = defaultMatcher.group("path");
        String version = log4jMatcher.group("version");
        String repository = log4jMatcher.group("repository");
        return LogInformation.builder().assetName(assetName).ipAddress(ip).user(user.equals("-") ? "anonymous" : user).dateTime(dateTime).path(path).version(version).repository(repository).build();
    }
}

