/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal.legal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.nexus.vulnerability.Log4JVisualizerManager;
import com.sonatype.nexus.vulnerability.internal.capability.Log4JVisualizerCapability;
import com.sonatype.nexus.vulnerability.internal.legal.Log4JVisualizerConfigurationStore;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
public class Log4JVisualizerManagerImpl
extends ComponentSupport
implements Log4JVisualizerManager {
    private final Log4JVisualizerConfigurationStore store;
    private final CapabilityRegistry capabilities;
    private final TaskScheduler taskScheduler;
    private final String vulnerabilityStatisticsCron;

    @Inject
    public Log4JVisualizerManagerImpl(Log4JVisualizerConfigurationStore store, CapabilityRegistry capabilityRegistry, TaskScheduler taskScheduler, @Named(value="${nexus.vulnerabilityStatistics.cron:-0 4 0 * * ?}") String vulnerabilityStatisticsCron) {
        this.store = (Log4JVisualizerConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.vulnerabilityStatisticsCron = vulnerabilityStatisticsCron;
    }

    @Override
    public boolean isLog4JVisualizerEnabled() {
        return this.store.isEnabled().orElse(false);
    }

    @Override
    public void setLog4JVisualizerEnabled(boolean enabled, boolean updateCapabilityState) {
        this.store.setEnabled(enabled);
        if (updateCapabilityState) {
            this.updateLog4JVisualizerCapability(enabled);
        }
        this.updateVulnerabilityStatisticTaskVisibility(enabled);
    }

    private void updateVulnerabilityStatisticTaskVisibility(boolean enabled) {
        if (enabled) {
            this.installVulnerabilityStatisticsTask();
        } else {
            this.uninstallVulnerabilityStatisticsTask();
        }
    }

    private void updateLog4JVisualizerCapability(boolean enabled) {
        Optional<CapabilityContext> capability = this.findLog4jVisualizerCapability();
        if (capability.isPresent()) {
            CapabilityContext context = capability.get();
            boolean capabilityEnabled = context.isEnabled();
            if (capabilityEnabled != enabled) {
                this.capabilities.update(context.id(), enabled, context.notes(), context.properties());
            }
        } else if (enabled) {
            this.capabilities.add(Log4JVisualizerCapability.TYPE, true, "Automatically added on " + new Date(), null);
        }
    }

    private Optional<CapabilityContext> findLog4jVisualizerCapability() {
        Collection references = this.capabilities.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(Log4JVisualizerCapability.TYPE));
        if (references.isEmpty()) {
            return Optional.empty();
        }
        CapabilityContext context = ((CapabilityReference)references.iterator().next()).context();
        return Optional.of(context);
    }

    private void installVulnerabilityStatisticsTask() {
        boolean existingTask = this.taskScheduler.listsTasks().stream().anyMatch(info -> "repository.vulnerability.statistics".equals(info.getConfiguration().getTypeId()));
        if (existingTask) {
            return;
        }
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.vulnerability.statistics");
        Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.vulnerabilityStatisticsCron);
        this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
    }

    private void uninstallVulnerabilityStatisticsTask() {
        TaskInfo info = this.taskScheduler.getTaskByTypeId("repository.vulnerability.statistics");
        if (info != null) {
            info.remove();
        }
    }
}

