/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.vulnerability.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.nexus.vulnerability.internal.AggregatedDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DayDownloadCount;
import com.sonatype.nexus.vulnerability.internal.DownloadCountStore;
import com.sonatype.nexus.vulnerability.internal.log.VulnerabilityInfoService;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class Log4jVisualizerAnalytics
implements AnalyticsMarker {
    private final MetricRegistry metricRegistry;
    private final VulnerabilityInfoService vulnerabilityInfoService;
    private final SecurityHelper securityHelper;
    private final DownloadCountStore downloadCountStore;
    private final Map<String, AtomicInteger> log4jVisualizerUserAccessCount = new ConcurrentHashMap<String, AtomicInteger>();
    private final AtomicInteger log4jVisualizerPageLoadCount = new AtomicInteger();

    @Inject
    public Log4jVisualizerAnalytics(MetricRegistry metricRegistry, VulnerabilityInfoService vulnerabilityInfoService, SecurityHelper securityHelper, DownloadCountStore downloadCountStore) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.vulnerabilityInfoService = (VulnerabilityInfoService)((Object)Preconditions.checkNotNull((Object)((Object)vulnerabilityInfoService)));
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.downloadCountStore = (DownloadCountStore)Preconditions.checkNotNull((Object)downloadCountStore);
    }

    public void incrementPageLoadCount() {
        this.log4jVisualizerPageLoadCount.incrementAndGet();
        String userName = this.securityHelper.subject().getPrincipal().toString();
        this.incrementUserAccessCount(userName);
    }

    @CachedGauge(name="nexus.analytics.log4j_visualizer_page_load_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public int getPageLoadCount() {
        return this.log4jVisualizerPageLoadCount.getAndSet(0);
    }

    @CachedGauge(name="nexus.analytics.log4j_visualizer_page_user_access_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public int getUserAccessCount() {
        int userAccessCount = this.log4jVisualizerUserAccessCount.values().stream().mapToInt(AtomicInteger::get).sum();
        this.log4jVisualizerUserAccessCount.clear();
        return userAccessCount;
    }

    @CachedGauge(name="nexus.analytics.log4j_visualizer_vulnerable_download_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public long getVulnerableDownloadCount() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getDownloadCountByRepositoryName("", (String)entry.getKey(), (Collection)entry.getValue(), this.oneYearAgo(), this.present()).stream()).mapToLong(AggregatedDownloadCount::getDownloadCount).sum();
    }

    @CachedGauge(name="nexus.analytics.log4j_visualizer_vulnerable_daily_download_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public long getVulnerableDailyDownloadCount() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getDownloadsByDay("", (String)entry.getKey(), (Collection)entry.getValue(), this.yesterday(), this.present()).stream()).mapToLong(DayDownloadCount::getDownloadCount).sum();
    }

    @CachedGauge(name="nexus.analytics.log4j_visualizer_non_vulnerable_daily_download_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public long getNonVulnerableDailyDownloadCount() {
        return this.vulnerabilityInfoService.getVulnerableComponentsAndVersions().entrySet().stream().flatMap(entry -> this.downloadCountStore.getNonVulnerableDownloadsByDay("", (String)entry.getKey(), (Collection)entry.getValue(), this.yesterday(), this.present()).stream()).mapToLong(DayDownloadCount::getDownloadCount).sum();
    }

    private void incrementUserAccessCount(String userName) {
        this.log4jVisualizerUserAccessCount.putIfAbsent(userName, new AtomicInteger(1));
        this.log4jVisualizerUserAccessCount.get(userName).incrementAndGet();
    }

    private LocalDate oneYearAgo() {
        return LocalDate.now().minusYears(1L);
    }

    private LocalDate yesterday() {
        return LocalDate.now().minusDays(1L);
    }

    private LocalDate present() {
        return LocalDate.now();
    }
}

