/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal.restore;

import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import com.sonatype.repository.helm.orient.HelmRestoreFacet;
import com.sonatype.repository.helm.orient.internal.HelmFacet;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class HelmRestoreFacetImpl
extends FacetSupport
implements HelmRestoreFacet {
    private HelmFacet helmFacet;
    private final HelmAttributeParser helmAttributeParser;

    @Inject
    public HelmRestoreFacetImpl(HelmAttributeParser helmAttributeParser) {
        this.helmAttributeParser = helmAttributeParser;
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.helmFacet = (HelmFacet)this.facet(HelmFacet.class);
    }

    @Override
    @TransactionalTouchBlob
    public void restore(AssetBlob assetBlob, String path) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetKind assetKind = AssetKind.getAssetKindByFileName(path);
        HelmAttributes attributes = this.helmAttributeParser.getAttributes(assetKind, assetBlob.getBlob().getInputStream());
        Asset asset = this.helmFacet.findOrCreateAsset(tx, path, assetKind, attributes);
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)new AttributesMap()));
        tx.saveAsset(asset);
    }

    @Override
    @TransactionalTouchBlob
    public boolean assetExists(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository())) != null;
    }

    @Override
    public boolean componentRequired(String name) {
        return AssetKind.getAssetKindByFileName(name) != AssetKind.HELM_INDEX;
    }

    @Override
    public Query getComponentQuery(HelmAttributes attributes) {
        return Query.builder().where("name").eq((Object)attributes.getName()).and("version").eq((Object)attributes.getVersion()).build();
    }

    @Override
    public HelmAttributes extractComponentAttributesFromArchive(String blobName, InputStream is) throws IOException {
        AssetKind assetKind = AssetKind.getAssetKindByFileName(blobName);
        return this.helmAttributeParser.getAttributes(assetKind, is);
    }
}

