/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal.hosted;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.HelmFormat;
import com.sonatype.repository.helm.internal.util.HelmPathUtils;
import com.sonatype.repository.helm.orient.internal.hosted.HelmHostedFacet;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class HostedHandlers
extends ComponentSupport {
    private HelmPathUtils helmPathUtils;
    public final Handler get = context -> {
        String path;
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        if (assetKind == AssetKind.HELM_INDEX) {
            path = "index.yaml";
        } else {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            path = this.helmPathUtils.filename(state);
        }
        Content content = ((HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class)).get(path);
        return content != null ? HttpResponses.ok((Payload)content) : HttpResponses.notFound();
    };
    public final Handler upload = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = this.helmPathUtils.buildAssetPath(state);
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        ((HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class)).upload(path, context.getRequest().getPayload(), assetKind);
        return HttpResponses.ok();
    };
    public final Handler push = context -> {
        HelmHostedFacet hostedFacet = (HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)context.getRepository().facet(StorageFacet.class);
        PartPayload payload = this.getPartPayload(context);
        String fileName = payload.getName() != null ? payload.getName() : "";
        AssetKind assetKind = AssetKind.getAssetKindByFileName(fileName);
        Throwable throwable = null;
        Object var8_9 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, HelmFormat.HASH_ALGORITHMS);){
            String path = hostedFacet.getPath(tempBlob, assetKind);
            hostedFacet.upload(path, tempBlob, (Payload)payload, assetKind);
            return HttpResponses.created();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    };
    public final Handler delete = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = this.helmPathUtils.buildAssetPath(state);
        boolean deleted = ((HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class)).delete(path);
        return deleted ? HttpResponses.ok() : HttpResponses.notFound();
    };

    @Inject
    public HostedHandlers(HelmPathUtils helmPathUtils) {
        this.helmPathUtils = (HelmPathUtils)((Object)Preconditions.checkNotNull((Object)((Object)helmPathUtils)));
    }

    private PartPayload getPartPayload(Context context) {
        if (!context.getRequest().isMultipart()) {
            throw new ValidationErrorsException("request should be multipart");
        }
        return StreamSupport.stream(Objects.requireNonNull(context.getRequest().getMultiparts()).spliterator(), false).filter(partPayload -> "chart".equals(partPayload.getFieldName())).findFirst().orElseThrow(() -> new ValidationErrorsException("chart field required"));
    }
}

