/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal.hosted;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.HelmFormat;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import com.sonatype.repository.helm.orient.internal.HelmFacet;
import com.sonatype.repository.helm.orient.internal.hosted.HelmHostedFacet;
import com.sonatype.repository.helm.orient.internal.hosted.HelmHostedWritePolicySelector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class HelmHostedFacetImpl
extends FacetSupport
implements HelmHostedFacet {
    private final HelmAttributeParser helmAttributeParser;
    private HelmFacet helmFacet;

    @Inject
    public HelmHostedFacetImpl(HelmAttributeParser helmAttributeParser) {
        this.helmAttributeParser = helmAttributeParser;
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new HelmHostedWritePolicySelector());
        this.helmFacet = (HelmFacet)this.facet(HelmFacet.class);
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content get(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Optional<Asset> assetOpt = this.helmFacet.findAsset(tx, path);
        if (!assetOpt.isPresent()) {
            return null;
        }
        Asset asset = assetOpt.get();
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        return this.helmFacet.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public void upload(String path, Payload payload, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = ((StorageFacet)this.facet(StorageFacet.class)).createTempBlob(payload, HelmFormat.HASH_ALGORITHMS);){
            this.upload(path, tempBlob, payload, assetKind);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getPath(TempBlob tempBlob, AssetKind assetKind) throws IOException {
        if (assetKind != AssetKind.HELM_PACKAGE && assetKind != AssetKind.HELM_PROVENANCE) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream inputStream = tempBlob.get();){
            HelmAttributes attributes = HelmAttributeParser.validateAttributes(this.helmAttributeParser.getAttributes(assetKind, inputStream));
            String extension = assetKind.getExtension();
            String name = attributes.getName();
            String version = attributes.getVersion();
            return String.format("%s-%s%s", name, version, extension);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Asset upload(String path, TempBlob tempBlob, Payload payload, AssetKind assetKind) throws IOException {
        HelmAttributes attributes;
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)tempBlob);
        if (assetKind != AssetKind.HELM_PACKAGE && assetKind != AssetKind.HELM_PROVENANCE) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Throwable throwable = null;
        Object var8_8 = null;
        try (InputStream inputStream = tempBlob.get();){
            attributes = this.helmAttributeParser.getAttributes(assetKind, inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Asset asset = this.helmFacet.findOrCreateAsset(tx, path, assetKind, attributes);
        this.helmFacet.saveAsset(tx, asset, tempBlob, payload);
        return asset;
    }

    @Override
    @TransactionalDeleteBlob
    public boolean delete(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Optional<Asset> asset = this.helmFacet.findAsset(tx, path);
        if (!asset.isPresent()) {
            return false;
        }
        tx.deleteAsset(asset.get());
        return true;
    }
}

