/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal.createindex;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.database.HelmProperties;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import com.sonatype.repository.helm.internal.metadata.ChartIndex;
import com.sonatype.repository.helm.orient.internal.HelmFacet;
import com.sonatype.repository.helm.orient.internal.createindex.CreateIndexService;
import com.sonatype.repository.helm.orient.internal.metadata.IndexYamlBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class CreateIndexServiceImpl
extends ComponentSupport
implements CreateIndexService {
    private static final String API_VERSION = "v1";
    private IndexYamlBuilder indexYamlBuilder;

    @Inject
    public CreateIndexServiceImpl(IndexYamlBuilder indexYamlBuilder) {
        this.indexYamlBuilder = (IndexYamlBuilder)Preconditions.checkNotNull((Object)indexYamlBuilder);
    }

    @Override
    @TransactionalStoreBlob
    @Nullable
    public TempBlob buildIndexYaml(Repository repository) {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        HelmFacet helmFacet = (HelmFacet)repository.facet(HelmFacet.class);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        ChartIndex index = new ChartIndex();
        for (Asset asset : helmFacet.browseComponentAssets(tx, AssetKind.HELM_PACKAGE)) {
            this.parseAssetIntoChartEntry(index, asset);
        }
        index.setApiVersion(API_VERSION);
        index.setGenerated(new DateTime());
        return this.indexYamlBuilder.build(index, storageFacet);
    }

    private void parseAssetIntoChartEntry(ChartIndex index, Asset asset) {
        NestedAttributesMap formatAttributes = asset.formatAttributes();
        NestedAttributesMap assetAttributes = asset.attributes();
        ChartEntry chartEntry = new ChartEntry();
        chartEntry.setName((String)formatAttributes.get(HelmProperties.NAME.getPropertyName(), String.class));
        chartEntry.setVersion((String)formatAttributes.get(HelmProperties.VERSION.getPropertyName(), String.class));
        chartEntry.setDescription((String)formatAttributes.get(HelmProperties.DESCRIPTION.getPropertyName(), String.class));
        chartEntry.setIcon((String)formatAttributes.get(HelmProperties.ICON.getPropertyName(), String.class));
        chartEntry.setCreated(asset.blobCreated());
        List maintainers = (List)formatAttributes.get(HelmProperties.MAINTAINERS.getPropertyName(), List.class);
        chartEntry.setMaintainers(maintainers);
        chartEntry.setAppVersion((String)formatAttributes.get(HelmProperties.APP_VERSION.getPropertyName(), String.class));
        chartEntry.setDigest(((Map)assetAttributes.get("checksum", Map.class)).get("sha256").toString());
        this.createListOfRelativeUrls(formatAttributes, chartEntry);
        chartEntry.setSources((List)formatAttributes.get(HelmProperties.SOURCES.getPropertyName(), List.class));
        index.addEntry(chartEntry);
    }

    private void createListOfRelativeUrls(NestedAttributesMap formatAttributes, ChartEntry chartEntry) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(String.format("%s-%s.tgz", formatAttributes.get(HelmProperties.NAME.getPropertyName(), String.class), formatAttributes.get(HelmProperties.VERSION.getPropertyName(), String.class)));
        chartEntry.setUrls(urls);
    }
}

