/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal.createindex;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.createindex.CreateIndexFacet;
import com.sonatype.repository.helm.internal.createindex.HelmIndexInvalidationEvent;
import com.sonatype.repository.helm.orient.internal.HelmFacet;
import com.sonatype.repository.helm.orient.internal.createindex.CreateIndexService;
import com.sonatype.repository.helm.orient.internal.hosted.HelmHostedFacet;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class CreateIndexFacetImpl
extends FacetSupport
implements CreateIndexFacet,
EventAware.Asynchronous {
    private final EventManager eventManager;
    private CreateIndexService createIndexService;
    private final long interval;
    private static final String INDEX_YAML = "index.yaml";
    private static final String TGZ_CONTENT_TYPE = "application/x-tgz";
    private final AtomicBoolean acceptingEvents = new AtomicBoolean(true);
    private final AtomicBoolean eventFired = new AtomicBoolean(false);

    @Inject
    public CreateIndexFacetImpl(EventManager eventManager, CreateIndexService createIndexService, @Named(value="${nexus.helm.createrepo.interval:-1000}") long interval) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.createIndexService = (CreateIndexService)Preconditions.checkNotNull((Object)createIndexService);
        this.interval = interval;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent created) {
        this.maybeInvalidateIndex((AssetEvent)created);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent deleted) {
        this.maybeInvalidateIndex((AssetEvent)deleted);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetUpdatedEvent updated) {
        this.maybeInvalidateIndex((AssetEvent)updated);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(RepositoryCreatedEvent createdEvent) {
        this.log.debug("Initializing index.yaml for hosted repository {}", (Object)this.getRepository().getName());
        this.invalidateIndex();
    }

    private void maybeInvalidateIndex(AssetEvent event) {
        String assetKindString;
        AssetKind assetKind;
        Asset asset = event.getAsset();
        String formatName = asset.format();
        if ("helm".equals(formatName) && (assetKind = AssetKind.valueOf(assetKindString = (String)asset.formatAttributes().get("asset_kind"))) == AssetKind.HELM_PACKAGE && this.matchesRepository(event) && this.isEventRelevant(event)) {
            this.invalidateIndex();
        }
    }

    @Subscribe
    public void on(HelmIndexInvalidationEvent event) {
        if (this.shouldProcess(event)) {
            this.acceptingEvents.set(false);
            this.maybeWait(event);
            this.log.info("Rebuilding Helm index for repository {}", (Object)this.getRepository().getName());
            UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
            try {
                this.acceptingEvents.set(true);
                this.eventFired.set(false);
                this.updateIndexYaml(this.createIndexService.buildIndexYaml(this.getRepository()));
            }
            finally {
                this.log.info("Finished rebuilding Helm index for repository {}", (Object)this.getRepository().getName());
                UnitOfWork.end();
            }
        }
    }

    @TransactionalStoreBlob
    protected void updateIndexYaml(TempBlob indexYaml) {
        if (indexYaml == null) {
            this.deleteIndexYaml();
        } else {
            this.createIndexYaml(indexYaml);
        }
    }

    private void createIndexYaml(TempBlob indexYaml) {
        Repository repository = this.getRepository();
        HelmFacet helmFacet = (HelmFacet)repository.facet(HelmFacet.class);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        HelmAttributes attributes = new HelmAttributes(Collections.emptyMap());
        Asset asset = helmFacet.findOrCreateAsset(tx, INDEX_YAML, AssetKind.HELM_INDEX, attributes);
        try {
            helmFacet.saveAsset(tx, asset, indexYaml, TGZ_CONTENT_TYPE, null);
        }
        catch (IOException ex) {
            this.log.warn("Could not set blob {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void deleteIndexYaml() {
        this.log.debug("Empty index.yaml returned, proceeding to delete asset");
        HelmHostedFacet hosted = (HelmHostedFacet)this.getRepository().facet(HelmHostedFacet.class);
        boolean result = hosted.delete(INDEX_YAML);
        if (result) {
            this.log.info("Deleted index.yaml because of empty asset list");
        } else {
            this.log.warn("Unable to delete index.yaml asset");
        }
    }

    private boolean shouldProcess(HelmIndexInvalidationEvent event) {
        return this.getRepository().getName().equals(event.getRepositoryName());
    }

    private void maybeWait(HelmIndexInvalidationEvent event) {
        if (event.isWaitBeforeRebuild()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("Helm invalidation thread interrupted, proceeding with invalidation");
            }
        }
    }

    private boolean matchesRepository(AssetEvent assetEvent) {
        return assetEvent.isLocal() && this.getRepository().getName().equals(assetEvent.getRepositoryName());
    }

    private boolean isEventRelevant(AssetEvent event) {
        return event.getComponentId() != null;
    }

    @Override
    public synchronized void invalidateIndex() {
        if (this.acceptingEvents.get() && !this.eventFired.get()) {
            this.log.info("Scheduling rebuild of Helm metadata to start in {} seconds", (Object)(this.interval / 1000L));
            this.eventFired.set(true);
            this.eventManager.post((Object)new HelmIndexInvalidationEvent(this.getRepository().getName(), true));
        }
    }
}

