/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal;

import com.sonatype.repository.helm.HelmUploadHandlerSupport;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.HelmFormat;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import com.sonatype.repository.helm.orient.internal.hosted.HelmHostedFacet;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@Named(value="helm")
public class HelmUploadHandler
extends HelmUploadHandlerSupport {
    @Inject
    public HelmUploadHandler(ContentPermissionChecker contentPermissionChecker, HelmAttributeParser helmPackageParser, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(contentPermissionChecker, helmPackageParser, variableResolverAdapter, uploadDefinitionExtensions);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        HelmHostedFacet facet = (HelmHostedFacet)repository.facet(HelmHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        String fileName = payload.getName() != null ? payload.getName() : "";
        AssetKind assetKind = AssetKind.getAssetKindByFileName(fileName);
        Throwable throwable = null;
        Object var9_10 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, HelmFormat.HASH_ALGORITHMS);){
            UploadResponse uploadResponse;
            String path = facet.getPath(tempBlob, assetKind);
            this.ensurePermitted(repository.getName(), "helm", path, Collections.emptyMap());
            try {
                UnitOfWork.begin((Supplier)storageFacet.txSupplier());
                Asset asset = facet.upload(path, tempBlob, (Payload)payload, assetKind);
                uploadResponse = new UploadResponse(asset);
            }
            catch (Throwable throwable2) {
                UnitOfWork.end();
                throw throwable2;
            }
            UnitOfWork.end();
            return uploadResponse;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

