/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.internal.metadata.ChartIndex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class YamlParser
extends ComponentSupport {
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    public Map<String, Object> load(InputStream is) throws IOException {
        Preconditions.checkNotNull((Object)is);
        return (Map)this.mapper.readValue(is, MAP_TYPE_REFERENCE);
    }

    public String getYamlContent(ChartIndex index) {
        try {
            return this.mapper.writeValueAsString((Object)index);
        }
        catch (IOException ex) {
            this.log.error("Error in index.yaml", (Throwable)ex);
            return null;
        }
    }

    public void write(OutputStream os, ChartIndex index) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(os);){
                String result = this.getYamlContent(index);
                writer.write(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.log.error("Unable to write to OutputStream for index.yaml", (Throwable)ex);
        }
    }
}

