/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.util;

import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.database.HelmProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ProvenanceParser {
    public HelmAttributes parse(InputStream inputStream) throws IOException {
        HelmAttributes attributes = new HelmAttributes();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith(HelmProperties.NAME.getPropertyName())) {
                    attributes.setName(this.getValue(line));
                }
                if (line.startsWith(HelmProperties.DESCRIPTION.getPropertyName())) {
                    attributes.setDescription(this.getValue(line));
                }
                if (line.startsWith(HelmProperties.VERSION.getPropertyName())) {
                    attributes.setVersion(this.getValue(line));
                }
                if (line.startsWith(HelmProperties.ICON.getPropertyName())) {
                    attributes.setIcon(this.getValue(line));
                }
                if (!line.startsWith(HelmProperties.APP_VERSION.getPropertyName())) continue;
                attributes.setAppVersion(this.getValue(line));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return attributes;
    }

    private String getValue(String string) {
        return string.substring(string.indexOf(":") + 1).trim();
    }
}

