/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.util;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.internal.metadata.IndexYamlAbsoluteUrlRewriter;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class HelmPathUtils
extends ComponentSupport {
    private final IndexYamlAbsoluteUrlRewriter urlRewriter;

    @Inject
    public HelmPathUtils(IndexYamlAbsoluteUrlRewriter urlRewriter) {
        this.urlRewriter = (IndexYamlAbsoluteUrlRewriter)((Object)Preconditions.checkNotNull((Object)((Object)urlRewriter)));
    }

    public String filename(TokenMatcher.State state) {
        return this.match(state, "filename");
    }

    public String contentFilePath(TokenMatcher.State state, boolean isForwardingSlash) {
        String filename = this.filename(state);
        return isForwardingSlash ? String.format("/%s", filename) : filename;
    }

    public Optional<String> contentFileUrl(String filename, Content indexYaml) {
        return this.urlRewriter.getFirstUrl(indexYaml, filename);
    }

    public String extension(TokenMatcher.State state) {
        return this.match(state, "extension");
    }

    private String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        String result = (String)state.getTokens().get(name);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    public String buildAssetPath(TokenMatcher.State matcherState) {
        String filename = this.filename(matcherState);
        String extension = this.extension(matcherState);
        return String.valueOf(filename) + "." + extension;
    }

    public String buildContentAssetPath(TokenMatcher.State matcherState) {
        return String.format("/%s", this.buildAssetPath(matcherState));
    }
}

