/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.util;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.util.ProvenanceParser;
import com.sonatype.repository.helm.internal.util.TgzParser;
import com.sonatype.repository.helm.internal.util.YamlParser;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class HelmAttributeParser {
    private TgzParser tgzParser;
    private YamlParser yamlParser;
    private ProvenanceParser provenanceParser;

    @Inject
    public HelmAttributeParser(TgzParser tgzParser, YamlParser yamlParser, ProvenanceParser provenanceParser) {
        this.tgzParser = (TgzParser)Preconditions.checkNotNull((Object)tgzParser);
        this.yamlParser = (YamlParser)((Object)Preconditions.checkNotNull((Object)((Object)yamlParser)));
        this.provenanceParser = (ProvenanceParser)Preconditions.checkNotNull((Object)provenanceParser);
    }

    public HelmAttributes getAttributes(AssetKind assetKind, InputStream inputStream) throws IOException {
        switch (assetKind) {
            case HELM_PACKAGE: {
                return this.getAttributesFromInputStream(inputStream);
            }
            case HELM_PROVENANCE: {
                return this.getAttributesProvenanceFromInputStream(inputStream);
            }
        }
        return new HelmAttributes();
    }

    private HelmAttributes getAttributesProvenanceFromInputStream(InputStream inputStream) throws IOException {
        return this.provenanceParser.parse(inputStream);
    }

    private HelmAttributes getAttributesFromInputStream(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = this.tgzParser.getChartFromInputStream(inputStream);){
            return new HelmAttributes(this.yamlParser.load(is));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static HelmAttributes validateAttributes(HelmAttributes attributes) {
        if (StringUtils.isBlank((CharSequence)attributes.getName())) {
            throw new ValidationErrorsException("Metadata is missing the name attribute");
        }
        if (StringUtils.isBlank((CharSequence)attributes.getVersion())) {
            throw new ValidationErrorsException("Metadata is missing the version attribute");
        }
        return attributes;
    }
}

