/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.metadata;

import com.google.common.io.ByteStreams;
import com.sonatype.repository.helm.internal.metadata.IndexYamlAbsoluteUrlRewriterSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.thread.io.StreamCopier;

@Named
@Singleton
public class IndexYamlAbsoluteUrlRewriter
extends IndexYamlAbsoluteUrlRewriterSupport {
    private static final String YAML_CONTENT_TYPE = "text/x-yaml";

    @Nullable
    public Content removeUrlsFromIndexYaml(TempBlob index, AttributesMap attributes) {
        if (index == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = index.get();){
                return (Content)new StreamCopier(outputStream -> this.updateUrls(inputStream, (OutputStream)outputStream), input -> this.createContent((InputStream)input, attributes)).read();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Nullable
    public Content removeUrlsFromIndexYaml(Content index) {
        if (index == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = index.openInputStream();){
                return (Content)new StreamCopier(outputStream -> this.updateUrls(inputStream, (OutputStream)outputStream), input -> this.createContent((InputStream)input, index.getAttributes())).read();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Content createContent(InputStream input, AttributesMap attributes) {
        try {
            Content content = new Content((Payload)new BytesPayload(ByteStreams.toByteArray((InputStream)input), YAML_CONTENT_TYPE));
            attributes.forEach(attr -> {
                Object object = content.getAttributes().set((String)attr.getKey(), attr.getValue());
            });
            return content;
        }
        catch (IOException ex) {
            this.log.error("Error rewriting urls in index.yaml", (Throwable)ex);
            throw new UncheckedIOException(ex);
        }
    }
}

