/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.metadata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import com.sonatype.repository.helm.internal.util.JodaDateTimeSerializer;
import com.sonatype.repository.helm.util.JodaDateTimeDeserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public final class ChartIndex {
    private String apiVersion;
    private Map<String, List<ChartEntry>> entries = new HashMap<String, List<ChartEntry>>();
    @JsonSerialize(using=JodaDateTimeSerializer.class)
    @JsonDeserialize(using=JodaDateTimeDeserializer.class)
    private DateTime generated;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Map<String, List<ChartEntry>> getEntries() {
        return this.entries;
    }

    public void addEntry(ChartEntry chartEntry) {
        this.entries.computeIfAbsent(chartEntry.getName(), k -> new ArrayList()).add(chartEntry);
    }

    public void setEntries(Map<String, List<ChartEntry>> entries) {
        this.entries = entries;
    }

    public DateTime getGenerated() {
        return this.generated;
    }

    public void setGenerated(DateTime generated) {
        this.generated = generated;
    }
}

